/*** hashmap ***/
const Map = function Map(){
	var size = 0;
	var entry = new Object();
	this.put = function (key , value){
		if(!this.containsKey(key)){
			size ++ ;
		}
		entry[key] = value;
	}
	this.get = function (key){
		return this.containsKey(key) ? entry[key] : null;
	}
	this.remove = function ( key ){
		if( this.containsKey(key) && ( delete entry[key] ) ){
			size --;
		}
	}
	this.containsKey = function ( key ){
		return (key in entry);
	}
	this.keys = function (){
		var keys = new Array();
		for(var prop in entry){
			keys.push(prop);
		}
		return keys;
	}
	this.values = function(){
	    var values = new Array();
	    for(var prop in entry){
	      values.push(entry[prop]);
	    }
	    return values;
  	}
	this.size = function (){
		return size;
	}
	this.clear = function (){
		size = 0;
		entry = new Object();
	}
}

const $kutil={	
	/**
	encodeURI:function(val){
			//不会被此方法编码的字符：! @ # $& * ( ) = : / ; ? + '
			服务器端java.net.URLEncoder.encode(s, "utf-8") 解码结果
			!=%21 @=%40 #=%23 $=%24 &=%26 *=* (=%28 )=%29 ==%3D :=%3A /=%2F ;=%3B ?=%3F +=%2B '=%27 "=%22 **/ 
			/*** JS encodeURI一次的结果
			!=! @=@ #=# $=$ &=& *=* (=( )=) === :=: /=/ ;=; ?=? +=+ '=' "=%22
		return encodeURIComponent(val).replace(/\//g,'%2F').replace(/\+/g,'%2B')
		.replace(/\'/g,'%27').replace(/\&/g,'%26').replace(/\=/g,'%3D').replace(/%20/g,'+')
		.replace(/\?/g,'%3F').replace(/\#/g,'%23').replace(/\:/g,'%3A').replace(/\,/g,'%2C').replace(/\@/g,'%40').replace(/\$/g,'%24').replace(/\(/g,'%28').replace(/\)/g,'%29')
		.replace(/\;/g,'%3B').replace(/\"/g,'%22').replace(/\!/g,'%21')
	},**/
	regExp:{
		CHINESE_CHARACTER: /[\u4e00-\u9fa5]/,
		NAME: /^[a-zA-Z\u4e00-\u9fa5]+$/,
		HTTP_ALL: /http(s?):\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\’:+!]*([^<>\"\"])*/g,
		HTTP_STRICT: /((http|ftp|https):\/\/[\w\-_]+(\.[\w\-_]+)+([\w\-\.,@?^=%&amp;:\/~\+#]*[\w\-\@?^=%&amp;\/~\+#])?|www+(\.[\w\-_]+)+([\w\-\.,@?^=%&amp;:\/~\+#]*[\w\-\@?^=%&amp;\/~\+#])?)/gi,
		HTTP: /^http(s?):\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\’:+!]*([^<>\"\"])*$/,
		DOMAIN : /^(http|https|ws|wss):\/\/([^/:]+)(:\d*)?\//,
		EMAIL: /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i,
		NUMBER_AND_LETTER: /^([A-Z]|[a-z]|[\d])*$/,
		POSITIVE_NUMBER: /^[1-9]\d*$/,
		NON_NEGATIVE_NUMBER: /^(0|[1-9]\d*)$/,
		IP: /^((1?\d?\d|(2([0-4]\d|5[0-5])))\.){3}(1?\d?\d|(2([0-4]\d|5[0-5])))$/,
		URL: /^([a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?\.)+[a-zA-Z]{2,6}$/,
		PHONE: /^((0\d{2,3})-)?(\d{7,8})(-(\d{3,}))?$|^(13|14|15|17|18)[0-9]{9}$/,
		TELEPHONE: /^(13|14|15|17|18)[0-9]{9}$/,
		QQ: /^\d{1,10}$/,
		DATE: /^((?!0000)[0-9]{4}-((0[1-9]|1[0-2])-(0[1-9]|1[0-9]|2[0-8])|(0[13-9]|1[0-2])-(29|30)|(0[13578]|1[02])-31)|([0-9]{2}(0[48]|[2468][048]|[13579][26])|(0[48]|[2468][048]|[13579][26])00)-02-29)$/,
		POUND_TOPIC: /^#([^\/|\\|\:|\*|\?|\"|<|>|\|]+?)#/,
		AT: /(@[a-zA-Z0-9_\u4e00-\u9fa5（）()]+)(\W|$)/gi,
		DIR_NAME: /[\\/:*?\"<>|]/,
		EmplName: /[\\\/:*?\"'<>\{};#!|]/,
		PWD : /((?=.*\d)(?=.*\D)|(?=.*[a-zA-Z])(?=.*[^a-zA-Z]))^.{8,32}$/
	},	
	/**
	 * 数组排序
	 * arr可以是字符数组或者对象数组
	 */
	sortArray: function(arr, name, desc ){
		var low = 0;
		var high= arr.length-1;
		var tmp,j;
		while (low < high) {
			var pos1 = 0, pos2=0; 
			for(var i= low; i < high; ++i){
				var a= name?(arr[i][name]==undefined?"":arr[i][name]):arr[i];
				var b= name?(arr[i+1][name]==undefined?"":arr[i+1][name]):arr[i+1];
				if ( a > b) {
					tmp = arr[i]; arr[i]=arr[i+1];arr[i+1]=tmp;
					pos1 = i ;
				}
			}
			
			high = pos1;
			for(var j=high; j>low; --j){
				var a= name?(arr[j][name]==undefined?"":arr[j][name]):arr[j];
				var b= name?(arr[j-1][name]==undefined?"":arr[j-1][name]):arr[j-1];
				if (a < b) {
					tmp = arr[j]; arr[j]=arr[j-1];arr[j-1]=tmp;
					pos2 = j;
				}
			}
			low = pos2;
		}
		return desc?arr.reverse( ):arr;
	},
	random:function(len){
		let _chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'
		len = len || 32
		let maxPos = _chars.length
		let str = ''
		for (let i = 0; i < len; i++) {
			str += _chars.charAt(Math.floor(Math.random() * maxPos))
		}
		return str
	},
	// 获取url查询参数, 返回map结构
	getQueryParams: function(url){
		let obj = {}
		try{
			let params = url.split("?")[1].split("&")
			for (i = 0; i < params.length; i++) {
				let param = params[i].split("=");
				obj[param[0]] = param[1]
			}
		}catch(err){}
		return obj;
	},
	getQueryParam:function(url,name){
		var reg = new RegExp("(^|&)"+ name +"=([^&]*)(&|$)");
		var r = url.toString().substr(1).match(reg);
		if(r!=null)
			return  decodeURIComponent(r[2]); 
		return null;
	},
	randomColor:function(index){
		var notecolor = ['#008FEC','#F5BD70','#2AC175','#7CB5EC','#f56a00','#74AAE3','#8BBE79','#91C7AE','#D48265','#61A0A8','#f56a00','#CFE3FE', '#7265e6', '#ffbf00', '#00a2ae','#D35400','#C0392B','#16A085','#27AE60','#3498DB','#8E44AD','#34495E','#2F4554'];
		return notecolor[index % notecolor.length];				
	},			
	printCallStack:function(){
		try{
			var i = 0;
			var fun = arguments.callee;
			do{
				fun = fun.arguments.callee.caller;
				console.log(++i + ': ' + (fun!=null?fun:"") );
			} while (fun);
		}catch(e){
			console.error(e);
		}
	},
	iconUrl:function(path,size){
		var defaultSize = "";
		if(size==20 || size==64 || size==96){
			defaultSize="_"+size;
		}
		var suppertIcon = "ai,apk,asp,aspx,avo,bmp,catdrawing,catpart,catproduct,cdr,cpp,cs,css,csv,doc,docx,dps,dpt,dwg,eio,eml,et,ett,exb,exe,file,flv,gif,h,html,java,jpeg,jpg,js,jsp,md,mht,mhtl,mhtml,mid,mp3,mp4,mpeg,msi,odp,ods,odt,pdf,png,pps,ppt,pptx,prt,psd,py,rar,rm,rmvb,rtf,sld,sldprt,swf,tif,tiff,txt,url,wav,wma,wmv,wps,wpt,xls,xlsx,zip";
		if(path){
			var icons = suppertIcon.split(",");
			var type = path.substring(path.lastIndexOf(".")+1).toLowerCase();				
			for(var i=0;i<icons.length;i++){
				if(icons[i] == type ){
					return "/kabala/images/file_icons"+defaultSize+"/"+type+".png";
				}
			}
		}
		return "/kabala/images/file_icons"+defaultSize+"/file.png";
			
	},

	/**
	 * @Author: WuPeng(2020-06-11 13:14:07)
	 * 获取多少个月前, 支持跨年
	 * time: new Date( )
	 * return yyyyMMddHHmmss
	 */
	getPreMonthDay: function (date, monthNum) {
		let dateArr = $kutil.dateFormat(date, 'yyyy-MM-dd').split('-');
		let year = dateArr[0]   //获取当前日期的年份
		let month = dateArr[1]  //获取当前日期的月份
		let day = dateArr[2]    //获取当前日期的日
		let year2 = year
		let month2 = parseInt(month) - monthNum
		if (month2 <= 0) {
			year2 = parseInt(year2) - parseInt(month2 / 12 == 0 ? 1 : Math.abs(parseInt(month2 / 12)) + 1);
			month2 = 12 - (Math.abs(month2) % 12);
		}
		let day2 = day
		let days2 = new Date(year2, month2, 0)
		days2 = days2.getDate()
		if (day2 > days2) {
			day2 = days2
		}
		if (month2 < 10) {
			month2 = '0' + month2
		}
		return year2 + month2 + day2 + $kutil.dateFormat(date, 'HHmmss');
	},
	/**
	 * @Author: WuPeng(2020-06-11 13:14:07)
	 * 获取多少个月后, 支持跨年
	 * time: new Date( )
	 * return yyyyMMddHHmmss
	 */
	getNextMonthDay: function(date, monthNum) {
		var dateArr = $kutil.dateFormat(date, 'yyyy-MM-dd').split('-');
		var year = dateArr[0]; //获取当前日期的年份
		var month = dateArr[1]; //获取当前日期的月份
		var day = dateArr[2]; //获取当前日期的日
		var days = new Date(year, month, 0);
		days = days.getDate(); //获取当前日期中的月的天数
		var year2 = year;
		var month2 = parseInt(month) + parseInt(monthNum);
		if (month2 > 12) {
			year2 = parseInt(year2) + parseInt((parseInt(month2) / 12 == 0 ? 1 : parseInt(month2) / 12));
			month2 = parseInt(month2) % 12;
		}
		var day2 = day;
		var days2 = new Date(year2, month2, 0);
		days2 = days2.getDate();
		if (day2 > days2) {
			day2 = days2;
		}
		if (month2 < 10) {
			month2 = '0' + month2;
		}
		return year2 + month2 + day2 + $kutil.dateFormat(date, 'HHmmss');
	},
	 /**
	 * @Author: WuPeng
	 * 转换当前时区日期到UTC日期
	 * !浏览器上的查询时间都需要调用这个函数,否则查询结果时间会有偏移!
	 * time: yyyyMMddHHmmss | new Date( )
	 * return yyyyMMddHHmmss
	 */
	cover2UTCTime: function(time, format){
		// 
		let date = undefined;
		if( Object.prototype.toString.call(time) == "[object Date]" ){
			date = time;
		}else{
			let stime = time.toString( );
			let year  = parseInt( stime.substr(0, 4) );
			let month = parseInt( stime.substr(4, 2) ) - 1;
			let day   = parseInt( stime.substr(6, 2) );
			let hh    = parseInt( stime.substr(8, 2) );
			let mm    = parseInt( stime.substr(10, 2) );
			let ss    = parseInt( stime.substr(12, 2) );

			let utclong = Date.UTC(year, month, day, hh, mm, ss, 0);
			date = new Date( utclong + (new Date( ).getTimezoneOffset( ) * 60000) );
		}

		// 格式化时间, 协调世界时 0 时区
		{
			let tf = function(i){return (i < 10 ? '0' : '') + i};
			if(!format){ format = "yyyyMMddHHmmss"; }
			res = format.replace(/yyyy|MM|dd|HH|mm|ss/g, function(a){
				switch(a){
				case 'yyyy':
					return tf(date.getUTCFullYear( ));
					break;
				case 'MM':
					return tf(date.getUTCMonth( ) + 1);
					break;
				case 'dd':
					return tf(date.getUTCDate( ));
					break;
				case 'HH':
					return tf(date.getUTCHours( ));
					break;
				case 'mm':
					return tf(date.getUTCMinutes( ));
					break;
				case 'ss':
					return tf(date.getUTCSeconds( ));
					break;
				}
			})
		}
		return res;
	},
	/**
	 * @Author: WuPeng
	 * 转换时间|对象到指定格式
	 * time: yyyyMMddHHmmss | new Date( )
	 * return yyyyMMddHHmmss
	 */
	dateFormat:function(time, format){
		var t = Object.prototype.toString.call(time) == "[object Date]"?time:new Date(parseInt(time+""));
		if(!format){ format = "yyyyMMddHHmmss"; }
		var tf = function(i){return (i < 10 ? '0' : '') + i};
		return format.replace(/yyyy|MM|dd|HH|mm|ss/g, function(a){
			switch(a){
			case 'yyyy':
				return tf(t.getFullYear( ));
				break;
			case 'MM':
				return tf(t.getMonth( ) + 1);
				break;
			case 'dd':
				return tf(t.getDate( ));
				break;
			case 'HH':
				return tf(t.getHours( ));
				break;
			case 'mm':
				return tf(t.getMinutes( ));
				break;
			case 'ss':
				return tf(t.getSeconds( ));
				break;
			}
		})
	},
	/**
	 * @Author: WuPeng
	 * 加载js和css文件
	 */
	loadsSource: function(src, callback){
		let head = ""; src = src.split('?')[0];
		let filetype = src.substring(src.lastIndexOf(".") + 1).toLowerCase();
		try { head = document.getElementsByTagName('head')[0]; }catch (e) {};
		let addobj = {};
		if(filetype == "js"){
			addobj = document.createElement('script');
		　　addobj.setAttribute("type","text/javascript");
		　　addobj.setAttribute("src", src);
		}else if(filetype == "css"){
		　	addobj = document.createElement('link');
		　　addobj.setAttribute("rel","stylesheet");
		　　addobj.setAttribute("type","text/css");
		　　addobj.setAttribute("href", src);
		}
		addobj.onload = addobj.onreadystatechange = function() {
			if ((!this.readyState || this.readyState === "loaded" || this.readyState === "complete")) {
				try {callback();} catch (e) {};
				addobj.onload = addobj.onreadystatechange = null;
				if (head && addobj.parentNode) {
					head.removeChild(addobj);
				}				
			}
		};
		head.insertBefore( addobj, head.firstChild );
	},
	/**
	 * @Author: WuPeng
	 * 追加CSS
	 */
	appendCSS: function( css ){
		let style = document.createElement("style");
		style.type = "text/css";
		try{ style.appendChild(document.createTextNode(css)); }catch(ex){ style.styleSheet.cssText = css; }
		(document.getElementsByTagName("head")[0]).appendChild(style)
	},
	// 数字简写
	numberShortConvert: function(num, fiexd, toString){
		let obj = $kutil.unitConvert(num, 10000, undefined == fiexd ? 2 : fiexd, ["", "W"]);
		if(undefined != toString && !toString){
			return obj;
		}
		return obj.num+obj.unit;
	},
	// 文件大小
	fileSizeConvert: function(num, fiexd, toString){
		let obj = $kutil.unitConvert(num, 1024, undefined == fiexd ? 2 : fiexd, ["byte", "KB", "MB", "GB", "TB", "PB"]);
		if(undefined != toString && !toString){
			return obj;
		}
		return obj.num+obj.unit;
	},
	// 数字单位转换
	unitConvert: function(num, span, fiexd, units){
		let _units = units?units.concat([]):[];
		let _span = Number(span);
		let _num = Number(num);
		let m = {num: 0, unit: ""} 
		if(_units.length == 0){
			return m;
		}
		if( !_num || !_span ){
			m.unit = _units[0];
			return m;
		}
		// 选中第一个单位 
		let curentUnit = _units[0];
		let spanlenth = $kutil.strNumSize(span);
		let numlength = $kutil.strNumSize(_num);
		let b = Math.floor(numlength/spanlenth);
		if( b > 0 ){
			if( b >= _units.length ){
			b = _units.length - 1;
			}
			curentUnit = _units[ b ];
			_num = _num / Math.pow(_span, b); 
		}
		// 最终结果
		m.num = _num.toFixed(fiexd)
		m.unit = curentUnit;
		return m;
	},
	// 获取整数部分的长度
	strNumSize: function(tempNum){ 
		let stringNum = tempNum.toString() 
		let index = stringNum.indexOf(".") 
		let newNum = stringNum;
		if(index!=-1){
			newNum = stringNum.substring(0,index) 
		} 
		return newNum.length
	},
	// 判断是否是 XX 类型
	isType: function( obj, type ){
		try{
		var testType = Object.prototype.toString.call(obj).slice(8,-1).toLowerCase( );
		return (testType === type.toLowerCase( )); 
		}catch( e ){
		return false;
		}
	},
	/**
	 * 拓展|覆盖对象属性 
	 * B_IsCopy 指定是否使用拷贝的方式给原有对象添加属性, 默认使用拷贝方式
	 */ 
	extendAttrs: function( OB_Src, OB_Add, B_IsCopy ){
		if( !OB_Src ){
			return OB_Add;
		}
		if(!$kutil.isType( OB_Src, "object" )){
			OB_Src = {};
		}
		for( var Tx_Key in OB_Add){
			if($kutil.isType( OB_Add[ Tx_Key ], "object" ) && B_IsCopy !== false ){
				OB_Src[ Tx_Key ] = $kutil.extendAttrs(OB_Src[Tx_Key], OB_Add[ Tx_Key ]);
			}else{
				OB_Src[Tx_Key] = OB_Add[ Tx_Key ];
			}
		} 
		return OB_Src; 
	},
	// 检查平台
	checkPlatform: function( typeStr ){ 
		let res = {
		  Win: /Win/i.test(navigator.platform),
		  Mac: /Mac/i.test(navigator.platform),
		  Linux: /Linux/i.test(navigator.platform),
		  iOS: /iOS/i.test(navigator.platform),
		};
		if( typeStr ){
		  return res[ typeStr.toString( ) ];
		}else{
		  return res;
		}
	},
	/**
	 * 判断设备类型 安卓|IOS Web|App
	 * @return {[type]} [description]
	 */
	checkBrowser: function( typeStr ){
		let res = {
			Mobile: false,
			App: false,
			Iso: false,
			Android: false,
			IsoApp: false,
			AndroidApp: false,
			Browser: false,
		};
		try{
			var ua = navigator.userAgent.toLowerCase( );
			// console.log( ua )
			res.Mobile = ua.indexOf('mobile') > -1;
			res.Iso = /\b(ipad|iphone|ipod)(?=;)/.test(ua);
			res.Android = ua.indexOf('android') > -1;
			try{
			res.App = ($kmobilebridge||window.$kmobilebridge)?true:false;
			}catch(err){}
			res.DingTalk = ua.indexOf('dingtalk') > -1;
			res.WeiXin = ua.match(/MicroMessenger/i)=="micromessenger";
			res.WeiXinMiniProgram = res.WeiXin && ua.indexOf('miniprogram') > -1;
			res.IsoApp = res.App && res.Iso;
			res.AndroidApp = res.App && res.Android;
			res.Browser = !res.IsoApp && !res.AndroidApp;
		}catch(err){}
		
		if( typeStr ){
			return res[ typeStr.toString( ) ];
		}else{
			return res;
		}
	},

	// 获取今天凌晨
	getTerdayStart: function( ){
		var date = new Date( );
		date.setHours( 0, 0, 0, 0 );
		return date;
	},
	// 获取昨天日期
	getYesterday: function( ){
		var date = new Date( );
		date.setHours( 0, 0, 0, 0 );
		date.setDate( date.getDate( ) - 1 );
		return date;
	},
	// 获取本周的第一天
	getCurrentWeekFirst: function( ){
		var date = new Date( );
		date.setHours( 0, 0, 0, 0 );
		date.setDate( date.getDate( ) - (date.getDay( )||7)+1 );
		return date;
	},
	// 获取本周的最后一天
	getCurrentWeekLast: function( ){
		var date = new Date( );
		date.setHours( 0, 0, 0, 0 );
		date.setDate( date.getDate( ) - (date.getDay( )||7)+1 );
		date.setDate( date.getDate( )+6 );
		return date;
	},
	// 获取当前月的第一天
	getCurrentMonthFirst: function( ){
		var date = new Date( );
		date.setDate(1);
		date.setHours(0, 0, 0, 0);
		return date;
	},
	// 获取当前月的最后一天
	getCurrentMonthLast: function( ){
		var date = new Date( );
		date.setMonth( date.getMonth( ) + 1 );
		date.setDate(0);
		date.setHours(23, 59, 59, 0);
		return date;
	},
	// 获取上个月的第一天
	getAfterMonthFirst: function( ){
		var date = new Date( );
		date.setMonth( date.getMonth( ) - 1 );
		date.setDate(1);
		date.setHours(0, 0, 0, 0);
		return date;
	},
	// 获取上个月的最后一天
	getAfterMonthLast: function( ){
		var date = new Date( );
		date.setDate(0);
		date.setHours(23, 59, 59, 0);
		return date;
	},
	// 获取前30日
	getthryday: function( ){
		var date = new Date( );
		date.setHours( 0, 0, 0, 0 );
		date.setDate( date.getDate( ) - 30 );
		return date;
	},
	// 获取前7日
	getsevday: function( ){
		var date = new Date( );
		date.setHours( 0, 0, 0, 0 );
		date.setDate( date.getDate( ) - 7 );
		return date;
	},
	// 获取最近多少天的时间列表
	getRecentDateList: function( count, format ){
		var result = [];
		if( count ){
			for (var i = 0; i < count; i++) {
				let date = new Date( );
				date.setDate(date.getDate( ) - i);
				date.setHours(0, 0, 0, 0);
				result.push( $kutil.dateFormat(date, format) );
			}
		}
		return result;
	},
	// 格式化mb大小
	formatMbSize:function(filesize){
		if(!filesize){
			return "0 M";
		}
		return $kutil.formatSize(parseInt(filesize+"")*1024*1024);
	},	
	formatSize:function(fileSize){
		try{
			if(fileSize==0){
				return "0 KB";
			}
			if(fileSize < 1024){
				return fileSize+" byte";
			}else if (fileSize<(1024*1024)) {
				var temp = fileSize / 1024;
				temp = temp.toFixed(0);
				return temp + ' KB';
			}else if (fileSize<(1024*1024*1024)) {
				var temp = fileSize / (1024*1024);
				if(temp.toFixed(1).endWith(".0")){
					return temp.toFixed(0)+ ' MB';
				}else{
					return temp.toFixed(2) + ' MB';
				}
			}else if( fileSize<(1024*1024*1024*1024) ){
				var temp = fileSize / (1024*1024*1024);
				if(temp.toFixed(2).endWith(".00")){
					return temp.toFixed(0)+ ' GB';
				}else{
					return temp.toFixed(2) + ' GB';
				}
			}else{
				var temp = fileSize / (1024*1024*1024*1024);
				if(temp.toFixed(3).endWith(".000")){
					return temp.toFixed(0)+ ' TB';
				}else{
					return temp.toFixed(3) + ' TB';
				}
			}
		}catch(e){
			return filesize;
		}
	},
	
	formatSize2:function(fileSize){
		try{
			if(fileSize==0){
				return "0";
			}
			if(fileSize < 1024){
				return fileSize;
			}else if (fileSize<(1024*1024)) {
				var temp = fileSize / 1024;
				temp = temp.toFixed(0);
				return temp ;
			}else if (fileSize<(1024*1024*1024)) {
				var temp = fileSize / (1024*1024);
				if(temp.toFixed(1).endWith(".0")){
					return temp.toFixed(0);
				}else{
					return temp.toFixed(2);
				}
			}else if( fileSize<(1024*1024*1024*1024) ){
				var temp = fileSize / (1024*1024*1024);
				if(temp.toFixed(2).endWith(".00")){
					return temp.toFixed(0);
				}else{
					return temp.toFixed(2);
				}
			}else{
				var temp = fileSize / (1024*1024*1024*1024);
				if(temp.toFixed(3).endWith(".000")){
					return temp.toFixed(0);
				}else{
					return temp.toFixed(3);
				}
			}
		}catch(e){
			return filesize;
		}
	},
	
	date2time:function(date,timezone){
		var timenum = moment(date).format('YYYYMMDDHHmmss');	
		return $kutil.formatTime(timenum,timezone);
	},
	formatDateObject:function (timenum, timezone){
		if(timenum<0){
			return "";
		}
		if(typeof(timezone)=='undefined'){
			try{
				timezone = parseInt($khttp.session().timezone);
			}catch(e){
				timezone=8;
			}
		}
		var stime = timenum+'';
		var year = stime.substr(0, 4);
		var month = stime.substr(4, 2);
		var day = stime.substr(6, 2);
		var hh = stime.substr(8, 2);
		var mm = stime.substr(10, 2);
		var ss = stime.substr(12, 2);
		
		var utcLongTime = Date.UTC(parseInt(year), parseInt(month)-1, parseInt(day), parseInt(hh), parseInt(mm), parseInt(ss), 0);
		var d = new Date(utcLongTime);
		var localTime = d.getTime();
		var localOffset = d.getTimezoneOffset() * 60000; /*** 返回格林威治时间和本地时间之间的时差，以分钟为单位。 ***/
		var utc = localTime + localOffset;
		var calctime = utc + (3600000*timezone); 
		return new Date(calctime); 		
	},
	formatTime:function(timenum,timezone){
		if(timenum==undefined || timenum<0){
			return "";
		}		
		var mydate = $kutil.formatDateObject(timenum, timezone);
		return moment(mydate).format("YYYY-MM-DD HH:mm");		
	},	
	formatRelativeTime:function (timenum, timezone) {		
		if(timenum<0){
			return "";
		}
		var mydate = $kutil.formatDateObject(timenum,timezone);//GMT+0时间
		var text = moment(mydate).format('YYYYMMDDHHmmss');
		//moment 是客户端时间...
		return moment(text, "YYYYMMDDhhmmss").fromNow();			
	},
	toPercent:function(num1,num2){
		return num1<=0 || num2<=0 ? 0 : (Math.round(num2 / num1 * 100));
	}, 
	//类型检查
	isArray:function(o){
		if(o==undefined){
			return false;
		}
		return Object.prototype.toString.call(o)=='[object Array]';
	},
	isString:function(o){
		if(o==undefined){
			return false;
		}
		return (typeof o)=="string";
	},		
	setCookie:function (cname, cvalue, exdays) {
		var expires ="";
		if(exdays!=undefined && exdays>0){
			var d = new Date();
			d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
			var expires = "expires=" + d.toUTCString() + ";";			
		}
		//$cookie.set("access","1");
		document.cookie = cname + "=" + cvalue + ";path=/;" + expires;
	},
	getCookie:function (cname) {
		var arr, reg = new RegExp("(^| )" + cname + "=([^;]*)(;|$)");
		if (arr = document.cookie.match(reg))
			return (arr[2]);
		else
			return null;
	},
	addEvent:function(obj,EventName,callBack){
		//给对象添加事件     
		if(obj.addEventListener){   //FF     
			obj.addEventListener(EventName,callBack,false);     
		}else if(obj.attachEvent){//IE        
			obj.attachEvent('on'+EventName,callBack);     
		}else{        
			obj["on"+EventName]=callBack;      
		}   
	},   
	isHTMLCollection:function(o){
		if(o==undefined){
			return false;
		}
		if(o.length==undefined){
			return false;
		}
		var type = o.toString();
		return type.startWith('[') && type.endWith(']');
	},
	dom:function(vue,ref){		
		if(vue==undefined){
			return null;
		}
		if((typeof vue) == "string" ){
			return document.getElementById(vue);
		}
		return vue.$refs[ref].$el;
	},
	hide:function(obj){
		if(obj==null || obj==undefined){return;}
		if($kutil.isHTMLCollection(obj)){
			for(var node in obj){
				node.style.display='none';  
			}
		}else{
			obj.style.display='none';				 
		}
	},
	show:function(obj){
		if(obj==null || obj==undefined){return;}
		if($kutil.isHTMLCollection(obj)){
			for(var node in obj){
				node.style.display='';  
			}
		}else{
			obj.style.display='';				 
		}
	},
	hasClass:function(obj, cls) { 		
		if(obj==null || obj==undefined || $kutil.isString(obj)){return false;}
		return obj.className!=undefined && obj.className.match(new RegExp('(\\s|^)' + cls + '(\\s|$)'));  
	}, 
	addClass:function(obj, cls) {  		
		
		if(obj==null || obj==undefined ){return;}
		if($kutil.isHTMLCollection(obj)){			
			if(obj.length<=0){
				return
			};
			for(var i =0;i<obj.length;i++){		
				var node = obj.item(i);
				if (!$kutil.hasClass(node, cls)) {  
					node.className += " " + cls;  
				}  
			}
			
		}else{			
			if (!$kutil.hasClass(obj, cls)){  
				obj.className += " " + cls;  	
			} 			
		}
	},
	removeClass:function(obj, cls) { 
		if(obj==null || obj==undefined){
			return;
		}
		if($kutil.isHTMLCollection(obj)){
			if(obj.length<=0){
				return;				
			};
			for(var i =0;i<obj.length;i++){		
				var node = obj.item(i);
				if ($kutil.hasClass(node, cls)) {  					
					var reg = new RegExp('(\\s|^)' + cls + '(\\s|$)');  
					node.className = node.className.replace(reg, '');  					
				}  
			}
		}else{
			if ($kutil.hasClass(obj, cls)) {  
				var reg = new RegExp('(\\s|^)' + cls + '(\\s|$)');  
				obj.className = obj.className.replace(reg, ' ');  
			} 
		}
		
	}, 
	toggleClass:function(obj,cls){  
		if(obj==null || obj==undefined){return;}
		if($kutil.isHTMLCollection(obj)){
			if(obj.length<=0){return};
			for(var i =0;i<obj.length;i++){		
				var node = obj.item(i);
				if ($kutil.hasClass(node, cls)) {  
					removeClass(node, cls);  
				}else{
					addClass(node, cls);  
				}  
			}
		}else{
			if($kutil.hasClass(obj,cls)){  
				removeClass(obj, cls);  
			}else{  
				addClass(obj, cls);  
			}  
		}		
	},	
	/***** APP/SPACE相关 *****/	
		
	getspacebytype:function(spacetype){
		if(spacetype==undefined || spacetype==null){
			return {};	
		}
		var spaces = $khttp.session().spaces;
		if(!spaces){
			return {};
		}	
		
		for(var i=0;i<spaces.length;i++){			
			if(spaces[i].spacetype == spacetype ){
				return spaces[i]; 
			}
		}	
		return {};
	},
	getspace:function(spacepath){
		if(spacepath==undefined || spacepath==null){
			return {};	
		}
		var spaces = $khttp.session().spaces;
		if(!spaces){
			return {};
		}
		for(var i=0;i<spaces.length;i++){			
			if(spacepath.startWith("@"+spaces[i].spaceid+"/") || spacepath==("@"+spaces[i].spaceid)){
				return spaces[i];
			}
		}	
		return {};
	},
	getspacename:function(spacepath){		
		try{
			var space = $kutil.getspace(spacepath);
			return space.spacename;
		}catch(e){
			return "";
		}
	},
	getspaceroot:function(spacepath){		
		try{
			var space = $kutil.getspace(spacepath);
			return space.spaceroot;
		}catch(e){
			return "";
		}
	},
	getspaceapiurl:function(spacepath){		
		try{
			var space = $kutil.getspace(spacepath);
			return space.spaceapi;
		}catch(e){
			return "";
		}
	},
	parsespacepath:function(spacepath){
		try{
			var space = $kutil.getspace(spacepath);
			return spacepath.replace(space.spaceroot, space.spacename);
		}catch(e){
			return spacepath;
		}
	}	
}