// 工具类
const { app, Menu } = require('electron');
const { FSTools, ReqTools, FrameTool, TrayTool } = require('ksdk');
// 全局配置
Menu.setApplicationMenu(null);
app.commandLine.appendSwitch('--no-sandbox');

// 日志模块设置
const log4js = require('log4js');
log4js.configure(require(FSTools.buildPath(__dirname, '/config/logger.js')).logger);
const logger = log4js.getLogger('kmain');
logger.info('kclient start in: ', __dirname);

// 配置默认请求设置
ReqTools.setLogger(log4js.getLogger('krequest'));
// 配置默认窗口选项
FrameTool.setDefaultOpts({
  icon: FSTools.buildPath(__dirname, '/icon/icon.ico')
});

// 启动页面程序 & 单实例
const { KLogin } = require('kframes');
const { KHelper } = require('kextends');
const KClient = require('kcomm/lib/kclient');
// version 
let electronVer = parseFloat(process.versions.electron);
if (electronVer == 1.8) {
  if (app.makeSingleInstance((args, workdir) => { logger.info('单例启动', workdir); })) {
    logger.info('第二次启动程序, 单实例模式退出程序.');
    KClient.doQuit(true); return;
  }
} else {
  if (!app.requestSingleInstanceLock()) {
    logger.info('第二次启动程序, 单实例模式退出程序.');
    KClient.doQuit(true); return;
  }
}

// ready start
app.on('ready', (e) => {
  try {
    new KLogin(log4js.getLogger('kframes')).doLoad();
    var appname = KClient.Config().name? KClient.Config().name :'开始云';
    TrayTool.new({ tips: appname, icon: FSTools.buildPath(__dirname, '/icon/icon_16.png') });
    KHelper.init();         // 助手事件
    KHelper.initTCPSupport();// 助手TCP
  } catch (err) {
    logger.error(err);
    app.quit();
  }
});

// 当运行第二个实例时
app.on('second-instance', (evt, cmd, wkdir) => {
  logger.info('主程序监听到第二次启动事件.');
  KClient.showCurrentFrame();
});

// 点击dock显示窗体 - macos
app.on('activate', (e) => {
  KClient.showCurrentFrame();
});

// 监听 - 窗口关闭
app.on('window-all-closed', () => {
  logger.info('window-all-closed');
  if (process.platform !== 'darwin') {
    app.quit();
  }
});

// 未捕获进程异常
process.on('uncaughtException', (err) => {
  logger.error(err);
});

// 记录程序的退出
process.on('exit', (code) => {
  logger.info('kclient exit: ', code);
});