"use strict";
/**
 * 其他工具函数
 * utils.js
 **/
module.exports = class {
	// 判断是否是 XX 类型
	static isType(obj, type) {
		try {
			let testType = Object.prototype.toString.call(obj).slice(8, -1).toLowerCase();
			return (testType === type.toLowerCase());
		} catch (e) {
			return false;
		}
	};
	// 拓展|覆盖对象属性 
	// B_IsCopy 指定是否使用拷贝的方式给原有对象添加属性, 默认使用拷贝方式
	static extendAttr(OB_Src, OB_Add, B_IsCopy) {
		if (!OB_Src) {
			return OB_Add;
		}
		if (!this.isType(OB_Src, "object")) {
			OB_Src = {};
		}
		for (let Tx_Key in OB_Add) {
			if (this.isType(OB_Add[Tx_Key], "object") && B_IsCopy !== false) {
				OB_Src[Tx_Key] = this.extendAttr(OB_Src[Tx_Key], OB_Add[Tx_Key]);
			} else {
				OB_Src[Tx_Key] = OB_Add[Tx_Key];
			}
		}
		return OB_Src;
	};
	// 随机数
	static random(len) {
		let chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'
		len = len || 32
		let maxPos = chars.length
		let str = ''
		for (let i = 0; i < len; i++) {
			str += chars.charAt(Math.floor(Math.random() * maxPos))
		}
		return str
	};
	// 计算百分比
	static calcPercentage(x, y) {
		if (!x || !y || x == 0 || y == 0) {
			return 0;
		}
		let res = Math.round(x / y * 1000) / 10
		return res > 100 ? 100 : res;
	};
	// 文件大小
	static fileSizeConvert(num, fiexd, toString) {
		let obj = this.unitConvert(num, 1024, undefined == fiexd ? 2 : fiexd, ["byte", "KB", "MB", "GB", "TB", "PB"]);
		if (undefined != toString && !toString) {
			return obj;
		}
		return obj.num + obj.unit;
	};
	// 数字单位转换
	static unitConvert(num, span, fiexd, units) {
		let _units = units?units.concat([]):[];
		let _span = Number(span);
		let _num = Number(num);
		let m = {num: 0, unit: ""} 
		if(_units.length == 0){
			return m;
		}
		if( !_num || !_span ){
			m.unit = _units[0];
			return m;
		}

		let i = Math.floor(Math.log(_num) / Math.log(_span));
		m.num = (_num / Math.pow(_span, i)).toFixed(fiexd);
		m.unit = _units[i];
		return m;
	};
	// 获取整数部分的长度
	static strNumSize(tempNum) {
		let stringNum = tempNum.toString()
		let index = stringNum.indexOf(".")
		let newNum = stringNum;
		if (index != -1) {
			newNum = stringNum.substring(0, index)
		}
		return newNum.length
	};
};