"use strict";
const request = require('request');
/**
 * 网络请求
 */
let defaultopts, defaultreqobj, logger = console;
module.exports = class {
    static get request() {
        return defaultreqobj ? defaultreqobj : request;
    };

    // 设置请求默认参数
    static setDefault(opts) {
        defaultopts = opts ? opts : {};
        defaultreqobj = request.defaults(defaultopts);
    };

    // 获取请求默认参数
    static getDefault() {
        return defaultopts;
    };

    // 设置日志记录器
    static setLogger(newlogger) {
        logger = newlogger ? newlogger : console;
    };

    // 构建有效载荷
    static buildPayload(params, encodeURI) {
        if (!params) { return ''; }
        // 去除无效字段
        let _params = new Object();
        for (let key in params) {
            if (params[key] == undefined || params[key] == null || params[key].length == 0) {
                continue;
            }
            if (params.hasOwnProperty(key)) {
                _params[key] = params[key];
            }
        }
        // 构建请求负载
        let payload = ''; let keys = Object.keys(_params);
        if (keys.length > 0) {
            let payloads = [];
            keys = keys.sort();
            for (let i = 0; i < keys.length; i++) {
                payloads.push(keys[i] + "=" + (encodeURI ? global.encodeURI(_params[keys[i]]) : _params[keys[i]]));
            }
            payload = payloads.join("&");
        }
        return payload;
    };

    // 构建请求URL
    static buildURL(url, params, encodeURI) {
        let qurey = params ? this.buildPayload(params, encodeURI) : '';
        return url + (qurey ? '?' + qurey : '');
    };

    // doRequest
    static doRequest(method, url, opts, cb) {
        try {
            logger.info(method, url, opts);
            let _do = this.request[method ? method.toLowerCase() : 'get'];
            return _do(url, opts ? opts : {}, cb ? (err, res, body) => {
                if (err) {
                    logger.error(err);
                }
                logger.info(body);
                if (cb) {
                    cb(err, body, res);
                }
            } : undefined);
        } catch (e) {
            logger.error(e);
        }
    };

};