"use strict";
/**
 * props.js
 *
**/
// 路径转换
String.prototype.parse2UnixPath = function () {
	let temp = this.toString().trim();
	if (temp.indexOf('\\') > -1) {
		temp = temp.replace(new RegExp("\\\\", "gm"), "/");
	}
	if (temp.indexOf('//') > -1) {
		temp = temp.replace(new RegExp('//', "gm"), '/');
	}
	let subindex = temp.lastIndexOf("/");
	if (subindex > -1 && subindex == temp.length - 1) {
		temp = temp.substring(0, subindex);
	}
	return temp;
};

// 替换字符
String.prototype.replaceAll = function (str, rstr) {
	return this.replace(new RegExp(str, "gm"), rstr);
};

// 格式化占位符
String.prototype.format = function () {
	if (arguments.length == 0) return this;
	let s = this.toString();
	for (let i = 0; i < arguments.length; i++)
		s = s.replaceAll("\\{" + i + "\\}", arguments[i]);
	return s;
};

// 获取绝对路径
String.prototype.getAbsolutePath = function (basePath) {
	try {
		let js_dir = basePath.parse2UnixPath();
		let relative_path_arry = this.toString().split("/");
		let upLevelCout = 0;
		let relative_path_splite = "";
		for (let i = 0; i < relative_path_arry.length; i++) {
			if (relative_path_arry[i] != ".." && relative_path_arry[i] != ".") {
				relative_path_splite += "/" + relative_path_arry[i];
			} else if (relative_path_arry[i] == "..") {
				upLevelCout++;
			}
		}
		for (let i = 0; i < upLevelCout; i++) {
			js_dir = js_dir.getParent();
		}
		js_dir += relative_path_splite;
		return js_dir.parse2UnixPath();
	} catch (e) {
		return basePath;
	}
};

// 得到名字
String.prototype.getName = function (getSuffixed) {
	let temp = this.toString().parse2UnixPath();
	temp = temp.substring(temp.lastIndexOf("/") + 1);
	if (getSuffixed == false && temp.lastIndexOf(".") != -1) {
		temp = temp.substring(0, temp.lastIndexOf("."));
	}
	return temp;
};

// 得到后缀 
String.prototype.getSuffixed = function (B_HavePoint) {
	let temp = this.getName();
	if (temp.lastIndexOf(".") == -1) {
		return "";
	}
	let subIndex = temp.lastIndexOf(".");
	if (B_HavePoint == false) {
		subIndex++;
	}
	temp = temp.substring(subIndex);
	return temp;
}

// 得到父级路径 
String.prototype.getParent = function () {
	let temp = this.parse2UnixPath();
	if (temp.indexOf("/") > -1) {
		temp = temp.substring(0, temp.lastIndexOf("/"));
		temp = (temp == "" ? "/" : temp);
	}
	return temp;
};

// 是否以XXX开始
String.prototype.startWith = function (str) {
	if (str == null || str == "" || this.length == 0 || str.length > this.length)
		return false;
	if (this.substr(0, str.length) == str)
		return true;
	else
		return false;
};

// 是否以XXX结束
String.prototype.endWith = function (str) {
	if (str == null || str == "" || this.length == 0 || str.length > this.length)
		return false;
	if (this.substring(this.length - str.length) == str)
		return true;
	else
		return false;
}

/*
* 获取协议头 默认 http
*/
String.prototype.URLProtocol = function (deft) {
	let serverStr = this.toString();
	if (serverStr) {
		if (serverStr.startWith("http://")) {
			return "http";

		} else if (serverStr.startWith("https://")) {
			return "https";
		}
	}
	return deft ? deft : "http";
};

// 获取完整ip地址格式
String.prototype.URLHost = function () {
	let temp = this.toString();
	let I_StartIndex = temp.startWith("http://") ? 7 : (temp.startWith("https://") ? 8 : 0);
	let I_EndIndex = temp.lastIndexOf(":") > 7 ? temp.lastIndexOf(":") : temp.length;
	return temp.substring(I_StartIndex, I_EndIndex);
};

// 获取ip地址端口
String.prototype.URLPort = function () {
	let lastIndex1 = this.lastIndexOf(":");
	let lastIndex2 = this.lastIndexOf("/");
	if (lastIndex2 < lastIndex1) {
		if (lastIndex1 > 0 && lastIndex1 < this.length && lastIndex1 > 3 && lastIndex2 > 5) {
			return this.substring(lastIndex1 + 1);
		}
	}
	return '';
}

// 获取完整地址后面的路径
String.prototype.URLPath = function () {
	return this.replace(/^.*?\:\/\/[^\/]+/, "");
};
/*
* 添加协议头 www.baidu.com ==> https://www.baidu.com
* 添加协议默认端口 https://www.baidu.com ===> https://www.baidu.com:443
* return https://www.baidu.com:443
*/
String.prototype.formatURL = function (deft) {
	let temp = this.toString();
	if (!temp) { return ""; }
	// www.baidu.com ==> https://www.baidu.com
	if (!temp.startWith("http://") && !temp.startWith("https://")) {
		temp = (deft ? deft : "http") + "://" + temp;
	}

	// https://www.baidu.com ===> https://www.baidu.com:443
	if (temp.startWith("http://") && temp.lastIndexOf(":") < 6) {
		temp += ":80";
	} else if (temp.startWith("https://") && temp.lastIndexOf(":") < 7) {
		temp += ":443";
	}
	return temp.toLowerCase();
};

/*
* 去掉协议头 https://www.baidu.com:443 ==> www.baidu.com:443
* 去掉协议默认端口 www.baidu.com:443 ===> www.baidu.com
* return www.baidu.com
*/
String.prototype.removeURLProtocol = function () {
	let temp = this.toString();
	if (!temp) { return ""; }
	if (temp.startWith("http://")) {
		temp = temp.substr(7);
		if (temp.endWith(":80")) {
			temp = temp.substr(0, temp.length - 3);
		}

	} else if (temp.startWith("https://")) {
		temp = temp.substr(8);
		if (temp.endWith(":443")) {
			temp = temp.substr(0, temp.length - 4);
		}
	}
	return temp;
};

// 获取文字Base64
String.prototype.getBase64 = function () {
	return Buffer.from(this.toString()).toString('base64');
};

// 解码文字Base64
String.prototype.getStr4Base64 = function () {
	return Buffer.from(this.toString(), 'base64').toString();
};

// 获取文字MD5
String.prototype.getMd5 = function (isUpperCase) {
	let strTemp = require('crypto').createHash("md5").update(this.toString()).digest("hex");
	if (isUpperCase == false) {
		return strTemp.toLowerCase();
	}
	return strTemp.toUpperCase();
};