"use strict";
const FSTools = require('./fstools');
const { BrowserWindow, Menu, Tray, nativeImage } = require('electron');
/**
* 窗口管理
**/
let FRAMES = new Object(), defaultFrameOpts = {};
module.exports.FrameTool = class {
  // 设置默认配置
  static setDefaultOpts(opts) {
    if (opts && opts.icon) {
      opts.icon = typeof opts.icon == 'string' ? nativeImage.createFromPath(opts.icon) : opts.icon;
    }
    defaultFrameOpts = opts ? opts : {};
  };

  // 新开一个窗体
  static create(key, opts) {
    if (!opts) {
      opts = {};
    }
    if (FRAMES[key]) {
      throw key + ' is created';
    }
    let win = new BrowserWindow(Object.assign(Object.assign({}, defaultFrameOpts), opts));
    this._versionCompatible(win);
    win.on('closed', (e) => { this.del(key); });
    win.on('ready-to-show', (e) => {
      if (process.argv && process.argv.indexOf('--opendevtool') > -1) {
        win.webContents.openDevTools({ mode: 'undocked' });
      }
    });
    FRAMES[key] = win;
    return FRAMES[key];
  };
  // 强制兼容最新函数 - 1.8.2 -> ~
  static _versionCompatible(win) {
    if (win) {
      if (!win.loadFile) {
        win.loadFile = (path, opts) => {
          win.loadURL('file:///' + this._getResourcesPath(path), opts);
        }
      }
    }
    //this.win.loadFile('./page/login.html');
  };
  // 获取资源绝对位置
  static _getResourcesPath(path) {
    path = FSTools.parsePath(path);
    if (FSTools.isExistsSync(path)) {
      return path;
    }
    let pathTemp = FSTools.parsePath(process.resourcesPath + '/app');
    while (pathTemp && pathTemp.length > 0) {
      let buildPath = FSTools.parsePath(path.getAbsolutePath(pathTemp));
      if (FSTools.isExistsSync(buildPath)) {
        return buildPath;
      }
      pathTemp = FSTools.getParent(pathTemp);
    }
  };

  // 获取某个窗体
  static get(key) {
    return FRAMES[key];
  }

  // 删除某个窗体
  static del(key) {
    delete FRAMES[key];
  }

  // 列出所有窗体名字(key)
  static keys() {
    return Object.keys(FRAMES);
  }

  // 列出所有窗体
  static list() {
    return FRAMES;
  }
};

/**
* 托盘工具
**/
let trayInstance;
module.exports.TrayTool = class {

  // 初始化一个托盘
  static new(opts) {
    if (!trayInstance) {
      let icon = typeof opts.icon == 'string' ? nativeImage.createFromPath(opts.icon) : opts.icon;
      trayInstance = new Tray(icon);
    }
    if (opts.tips) {
      trayInstance.setToolTip(opts.tips);
    }
    if (opts.click) {
      trayInstance.on('click', opts.click);
    }
  };

  // 设置托盘图标点击事件
  static onTrayClick(func, remother) {
    if (trayInstance) {
      if (remother) {
        trayInstance.removeAllListeners('click');
      }
      trayInstance.on('click', func ? func : function (e, b, p) { });
    }
  };

  // 设置托盘图标双击击事件
  static onTrayDoubleClick(func, remother) {
    if (trayInstance) {
      if (remother) {
        trayInstance.removeAllListeners('double-click');
      }
      trayInstance.on('double-click', func ? func : function (e, b, p) { });
    }
  };

  // 改变菜单 - 覆盖操作
  static setMenus(menus) {
    if (trayInstance) {
      trayInstance.setContextMenu(Menu.buildFromTemplate(menus));
    }
  };

  // 销毁菜单
  static destroy() {
    if (trayInstance) {
      trayInstance.destroy();
    }
  };
};
// new BrowserWindow().setAlwaysOnTop()