"use strict";
const { ipcRenderer } = require('electron');
/**
 * ipcRenderer 1.8.2 版本补丁
 * 模拟自定义的实现, 不保证和最新源代码完全一致 --wupeng
 */
if (!ipcRenderer.invoke) {
    ipcRenderer.invoke = (channel, ...args) => {
        return new Promise((resolve, reject) => {
            let handChanel = 'h-' + channel;
            let replaykey = handChanel + '-' + random(6);
            ipcRenderer.on(replaykey, (e, datas) => {
                if (datas.error) {
                    reject(new Error(datas.error));
                } else {
                    resolve(datas.datas);
                }
            });
            ipcRenderer.send(handChanel, replaykey, ...args);
        })
    };
}

// 随机数
function random(len) {
    let chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'
    len = len || 32
    let maxPos = chars.length
    let str = ''
    for (let i = 0; i < len; i++) {
        str += chars.charAt(Math.floor(Math.random() * maxPos))
    }
    return str
};
module.exports = ipcRenderer;