"use strict";
const KClient = require('kcomm/lib/kclient');
const KNormalFrame = require('./knormalframe');
const { KFrameAbstract, KSession, KRequest, TrayTool, FrameTool } = require('ksdk');
/**
  * 主页面
 **/
module.exports = class extends KFrameAbstract {
  constructor(logger) {
    super();
    this.logger = logger ? logger : console;
    this.win.on('close', (e) => {
      e.preventDefault();
      this.hide();
    });
  }

  // 窗口id
  ID() {
    return 'main';
  };

  // 窗口配置
  Opts() {
    return {
      show: false,
      frame: false,
      width: 1366,
      minWidth: 1366,
      minHeight: 768,
      height: 768,
      webPreferences: {
        nodeIntegration: true
      }
    }
  };

  // 注册事件函数
  IPCHandles(register) {
    // 主窗体: 显示窗口
    register('show', () => { this.show(); });
    // 主窗体: 最小化
    register('mini', () => { this.mini(); });
    // 主窗体: 隐藏
    register('hide', () => { this.hide(); });
    // 主窗体: 最大化 <-> 最小化
    register('togglemax', () => { this.togglemax(); });
    // 重定向window.open
    register('window.open', (e, url, title, opts) => {
      this.logger.info('window.open');
      try {
        if (opts && !opts.isloadfile && url.indexOf('http://') == -1 && url.indexOf('https://') == -1) {
          url = KRequest.buildURL(url);
        }
        let winid = KNormalFrame.mkWinID(url);
        let win = FrameTool.get(winid);
        if (!win) {
          new KNormalFrame(this.logger, url, title, opts);
        } else {
          win.show();
        }
      } catch (e) {
        this.logger.error(e);
      }
    });
  };

  // 显示主窗体
  show() {
    if (this.win && KSession.serverSession) {
      this.win.show();
      this.win.focus();
    }
  };

  // 尝试在网页登录
  async doLoad(opts) {
    return new Promise((resolve, reject) => {
      this.doRemoveHandle('loginsucceed');
      this.doRemoveHandle('loginfailed');
      this.doRegisterHandle('loginsucceed', (evt, session) => {
        this.doRemoveHandle('loginfailed');
        this.logger.info('loginsucceed', session);
        try {
          TrayTool.setMenus([
            { label: '打开', click: () => { this.show(); } },
            { label: '注销', click: () => { KClient.doLogout(); }, },
            { label: '退出', click: () => { KClient.doQuit(); }, }
          ]);
          TrayTool.onTrayClick(() => { this.show(); }, true);
        } catch (e) {
          this.logger.error(e);
        }
        KSession.setKServerSession(session);
        KClient.setCurrentFrame(this);
        resolve();
      }, true);
      this.doRegisterHandle('loginfailed', (evt, err) => {
        this.doRemoveHandle('loginsucceed');
        this.logger.error('loginfailed', err);
        reject(err);
      }, true);
      // 加载中转页面
      this.win.loadURL(KRequest.buildURL('/main/login/kclientosslogin.html', {
        userid: KSession.userAccount,
        password: opts.password,
        logintype: 'kclient',
      }));
    });
  };
};