"use strict";
const KMain = require('./kmain');
const Klogin = require('kapis/lib/klogin');
const KClient = require('kcomm/lib/kclient');
const { KFrameAbstract, KSession, ReqTools, TrayTool } = require('ksdk');
const npm = require('getmac');//获取mac地址
/**
  * 登录页面
  *
 **/
module.exports = class extends KFrameAbstract {
  constructor(logger) {
    super();
    this.logger = logger ? logger : console;
  };
  ID() {
    return 'login';
  }
  Opts() {
    return {
      width: 380,
      height: 480,
      show: false,
      frame: false,
      resizable: false,
      // alwaysOnTop: true,
      webPreferences: {
        nodeIntegration: true
      }
    };
  };
  IPCHandles(register) {
    // 窗体: 显示窗口
    register('show', () => { this.show(); });
    // 窗体: 最小化
    register('mini', () => { this.mini(); });
    // 窗体: 隐藏
    register('hide', () => { this.hide(); });
    // 窗体: 关闭
    register('close', () => {
      KClient.doQuit(true);
    });
    // 执行登录
    register('submitlogin', (e, opts) => {
      return this.submitLogin(opts ? opts : {});
    });
    // 设置session
    register('setsession', (evt, session) => {
      this.logger.info('setsession', session);
      KSession.setKServerSession(session);
      evt.returnValue = true;
    });
    // 注销
    register('dologout', (evt) => {
      KClient.doLogout(() => {
        TrayTool.setMenus([]);
        TrayTool.onTrayClick(() => { this.show(); }, true);
      });
    });
  };

  // 执行登录
  submitLogin(opts) {
    return new Promise((resolve, reject) => {
      try {
        
        KSession.conf(opts, () => {
          ReqTools.setDefault({
            headers: {
              'User-Agent': this.win.webContents.session.getUserAgent(),
            },
            proxy: KSession.netProxyURL
          });
          // 一次性登录密码
          Klogin.askoncepwd(KSession.userAccount, undefined != opts.LOGIN.password ? opts.LOGIN.password : '', npm.default() ).then((data) => {
            // 初始化主窗体
            new KMain(this.logger).doLoad({ password: data }).then(() => {
              // 返回登录成功
              resolve(true);
              this.hide();
            }).catch((err) => {
              this.logger.error(err);
              reject(err);
            });
          }).catch((err) => {
            this.logger.error(err);
            reject(err);
          });
        });


      } catch (err) {
        this.logger.error(err);
        reject(err);
      }
    });
  };

  // 显示登录窗口
  doLoad() {
    KClient.setCurrentFrame(this);
    this.win.loadFile('./page/login.html');
    this.win.once('ready-to-show', (e) => {
      this.win.show();
      this.win.focus();
      // this.win.webContents.openDevTools()
    });
    this.win.on('show', (e) => {
      try {
        TrayTool.setMenus([
          { label: '打开', click: () => { this.show(); } },
          { label: '退出', click: () => { KClient.doQuit(); }, }
        ]);
        TrayTool.onTrayClick(() => { this.show(); }, true);
      } catch (e) {
        this.logger.error(e);
      }
    })
  };
};