"use strict";
const { KDownloadTool } = require('kcomm');
const { FSTools, Utils } = require('kutils');
/**
 * 本地打开
 */
module.exports = class extends KDownloadTool {
    constructor(spacepath, kspace) {
        let os = require('os');
        super([spacepath], FSTools.parsePath(os.tmpdir() + '/kabalaclient/files/openaslocal/'), kspace);
        this.cachepath = '';
        this.KSpace = kspace;
    };
    // 构建item
    doBuildItem(item) {
        try {
            this.cachepath = FSTools.parsePath(this.localdir + '/' + item.node.cnum + '/' + item.src.getName());//item.node.cnum + item.src.getSuffixed());
            FSTools.removeSync(this.cachepath);
            item.dest = this.cachepath;
            this.logger.info('openaslocal', item);
        } catch (e) {
            let err = { error: e, msg: '下载失败[' + e.toString() + ']', stage: 'validation', opts: ['retray'] };
            if (e && e.code == 'EBUSY') {
                err.msg = '文件已经打开或被系统占用';
            }
            throw err;
        }
    };
    // 下载结束
    onTransferEnd(datas) {
        if (datas && datas.allcount == datas.allsucceed) {
            this.stop();
            openWithDefaultOption(this.cachepath);
        }
    };
    // 执行操作
    async doStart() {
        await this.doAction();
    };
};
// ----------------------
const childProcess = require('child_process');
// 执行本地cmd命令
function executeCmdAsync(cmdStr, callback, option) {
    return childProcess.exec(cmdStr, Utils.extendAttr({ "encoding": "utf-8" }, option), callback);
};

// 调用系统默认打开方式打开
function openWithDefaultOption(path, callback) {
    if (process.platform == 'win32') {
        return executeCmdAsync("attrib +r \"" + FSTools.parsePath(path) + "\" && explorer \"" + FSTools.parsePath(path) + "\"", callback);
    } else if (process.platform == 'darwin') {
        return executeCmdAsync("open \"" + FSTools.parsePath(path) + "\"", callback);
    } else {
        return executeCmdAsync("xdg-open \"" + FSTools.parsePath(path) + "\"", callback);
    }
};