"use strict";
const { KUploadTool } = require('kcomm');
const { FrameTool } = require('kutils');
const { dialog } = require('electron')
/**
 * 下载
 */
module.exports = class extends KUploadTool {
    constructor(spacedir, isfile, kspace) {
        super([], spacedir, kspace);
        this.isupfile = isfile;
        this.parentwin = FrameTool.get('main');
        if (!this.parentwin) {
            this.parentwin = FrameTool.get('login');
        }
    };
    // 下载结束
    onTransferEnd(datas) {
        if (datas && datas.allcount == datas.allsucceed) {
            this.stop();
        }
    };
    // 执行操作
    async doStart() {
        return new Promise((resovle, reject) => {
            this.parentwin.setAlwaysOnTop(true);
            Promise.resolve(dialog.showOpenDialog(this.parentwin, { title: this.isupfile ? '选择文件' : '文件夹', properties: [this.isupfile ? 'openFile' : 'openDirectory', 'multiSelections'] })).then((datas) => {
                this.parentwin.setAlwaysOnTop(false);
                let paths = typeof datas == 'object' && datas.filePaths ? datas.filePaths : datas;
                if (!paths || paths.length <= 0) {
                    // reject('取消操作');
                    return;
                }
                this.paths = paths;
                this.doAction().then(resovle).catch(reject);
            }).catch((err) => {
                this.parentwin.setAlwaysOnTop(false);
                this.logger.error(err);
            });
        })
    };
};