"use strict";
// khelper:submit
/**
 * askopen, askmodify, askdownload, askupload, askdiff, 
 */
const { Server } = require('./ws');
const log4js = require('log4js');
const logger = log4js.getLogger('khelper');
const KSession = require('ksdk/lib/ksession');
const ipcMain = require('ksdk/lib/kipcmain');
const KSpace = require('./copysdk/kapis/kspace');
module.exports = class {
    // 初始化数据
    static init() {
        ipcMain.handle('khelper:submit', async (e, type, session, opts) => {
            try {
                let ksession = new KSession({
                    APIHOST: {
                        protocol: session.accesskey.accessendpoint.URLProtocol(),
                        serveraddr: session.accesskey.accessendpoint.URLHost() + ':' + session.accesskey.accessendpoint.URLPort(),
                    }
                });
                ksession.setKServerSession(session);
                if (this[type]) {
                    await this[type](new KSpace(ksession), opts);
                } else {
                    throw '暂不支持该操作';
                }
            } catch (err) {
                logger.error(err); throw err;
            }
        });
    };
    // 初始化套接字
    static initTCPSupport() {
        let wss = new Server({
            host: '127.0.0.1',
            port: '5050',
            path: '/khelper',
        });
        wss.on('connection', (ws) => {
            ws.on('message', async (message) => {
                try {
                    ws.send('客户端正在处理...');
                    let params = JSON.parse(message);
                    try {
                        let session = params.session;
                        let ksession = new KSession({
                            APIHOST: {
                                protocol: session.accesskey.accessendpoint.URLProtocol(),
                                serveraddr: session.accesskey.accessendpoint.URLHost() + ':' + session.accesskey.accessendpoint.URLPort(),
                            }
                        });
                        ksession.setKServerSession(session);
                        let type = params.type;
                        if (this[type]) {
                            await this[type](new KSpace(ksession), params.opts);
                        } else {
                            throw '暂不支持该操作';
                        }
                    } catch (err) {
                        logger.error(err); throw err;
                    }
                } catch (err) {
                    ws.send('调用失败: ' + err.toString());
                    logger.error(err);
                }
                logger.info('khelper', message);
            });
            logger.info('助手远程服务已启动');
        });
    };
    //  TODO askdiff 
    // static async askdiff(kspace, opts) {
    //     try {

    //     } catch (err) {
    //         logger.error(err); throw err;
    //     }
    // };
    // askopen
    static async askopen(kspace, opts) {
        try {
            let openAsLocal = require('./lib/openaslocal');
            let oal = new openAsLocal(opts.filepath, kspace);
            oal.setLogger(logger);
            await oal.doStart();
        } catch (err) {
            logger.error(err); throw err;
        }
    };
    // askmodify
    static async askmodify(kspace, opts) {
        try {
            let editAsLocal = require('./lib/editaslocal');
            let eal = new editAsLocal(opts.filepath, kspace);
            eal.setLogger(logger);
            await eal.doStart();
        } catch (err) {
            logger.error(err); throw err;
        }
    };
    // askdownload
    static async askdownload(kspace, opts) {
        try {
            let askDownload = require('./lib/askdownload');
            let download = new askDownload(JSON.parse(opts.paths), kspace);
            download.setLogger(logger);
            await download.doStart();
        } catch (err) {
            logger.error(err); throw err;
        }
    };
    // askupload
    static async askupload(kspace, opts) {
        try {
            let askUpload = require('./lib/askupload');
            let upload = new askUpload(opts.dirpath, opts.isfile, kspace);
            upload.setLogger(logger);
            await upload.doStart();
        } catch (err) {
            logger.error(err); throw err;
        }
    };
}