/** 语言包模板(旧的模板也兼容)
	"use strict";
	;(function(root, f){
		$KabalaI18n.$extend('en-US', f());
	}(this, function( ){
		return {
			common: { // 分组, 不限层级.
				test: 'English Language Pack Test', // 具体值, 使用: common.test
			},
			project: {
				document: {
					test: 'English Language Pack Test', // 具体值, 使用: project.document.test
				}
			}
		};
	}));
**/
// $KabalaI18n 对象
"use strict";
; (function (root, f) {
	root.$KabalaI18n = f();
}(this, function () {
	return {
		__proto__: {
			__loaded_: {},
			__index_: {},
			// 当前的语言类型
			$nowlocale: function () {
				let lang = 'zh-CN';
				try {
					lang = localStorage.getItem('kabala.locale') || navigator.language || 'zh-CN'; // 'en-US';
					if (lang) {
						let ls = lang.split('-');
						lang = (ls[0].toLocaleLowerCase()) + '-' + (ls[1].toUpperCase());
					}
				} catch (e) { }
				return lang ? lang : 'zh-CN';
			},
			// 设置语言
			$setlocale: function (lang) {
				if (lang) {
					localStorage.setItem('kabala.locale', lang);
				} else {
					localStorage.removeItem('kabala.locale');
				}
			},
			/**
			 * 批量获取当前语言的翻译, 不依赖vue
			 * @param obj(object) 需要翻译的对象, 格式如: {自定义key: '语言包key', docmuent:'doc.document'}, 函数执行后会改变原有对象的value, 同时返回传入对象
			 * @param obj(string) 需要翻译的key, 格式如: doc.document, 返回翻译后的字符
			 * @return object {自定义key: '语言包key', docmuent:'文档'}
			 */
			$t: function (obj) {
				if (obj) {
					let lang = this.$nowlocale();
					if (lang && this[lang] && !$kutil.isType(this[lang], 'function')) {
						// 单个key翻译
						if ($kutil.isType(obj, 'string')) {
							obj = this._t(lang, obj);
						} else {
							// 批量翻译
							for (let key in obj) { obj[key] = this._t(lang, obj[key]); }
						}
					}
				}
				return obj;
			},
			// 查找单个语言包 & 缓存
			_t: function (lang, key) {
				if (this.__proto__.__index_ && this.__proto__.__index_[key]) {
					return this.__proto__.__index_[key];
				}
				let lastobj = this[lang]; let lks = key.split('.');
				for (let i = 0; i < lks.length; i++) {
					if (undefined == lastobj[lks[i]]) { break; }
					lastobj = lastobj[lks[i]]
				}
				let val = $kutil.isType(lastobj, 'string') ? lastobj : key;
				// 创建索引
				this.__proto__.__index_[key] = val; return val;
			},
			/**
			 * 批量加载语言包, 如果有语言设置则加载单个语言包, 否则加载默认语言
			 * @param url 语言包在系统位置, 如: /kabala/languages. 到文件夹即可
			 * @param force 忽略缓存, 强制加载
			 */
			$load: function (url, force) {
				let key = url + '/' + this.$nowlocale() + '.js';
				if ((force || !window.$KabalaI18n.__proto__.__loaded_[key]) && url) {
					window.$KabalaI18n.__proto__.__loaded_[key] = true;
					document.write("<script type='text/javascript' src='" + key + "'></script>");
				}
			},
			/**
			 * 拓展语言包对象 
			 * @param lang zh-CN ...
			 * @param obj: {msg:'message'} || {group:{msg:'message'}} 
			 */
			$extend: function (lang, obj) {
				this.__proto__.__index_ = {};
				this[lang] = $kutil.extendAttrs(this[lang], obj);
			},
		}
	};
}));

// 语言包加载和配置
if (typeof window.__kabala_i18n__ == "undefined") {
	window.__kabala_i18n__ = true;
	let base = '.';
	try {
		// 构造参数
		let splitStr = "@base";
		let currentScriptSrc = document.currentScript.src;
		if (currentScriptSrc) {
			let splitIndex = currentScriptSrc.indexOf(splitStr);
			if (splitIndex > -1) {
				let baseStr = currentScriptSrc.substring((parseInt(splitIndex + splitStr.length) + 1), currentScriptSrc.length - 1);
				if (baseStr) {
					base = baseStr;
				}
			}
		}
	} catch (err) {
		console.error(err);
	}
	// 导入js文件
	if (window.Vue) { document.write("<script type='text/javascript' src='" + base + "/lib/vue-i18n.min.js'></script>"); }
	if (window.iview) { $KabalaI18n.$load(base + '/lib/iview4/locale'); }
	$KabalaI18n.$load(base + '/languages');
}//endif
