"use strict";
// 
const Utils = require('kutils/lib/utils');
const KRequest = require('./krequest');
const Kcrypto = require('./kcrypto');
const {JSEncrypt} = require('./encrypt');
/**
 * 会话相关 - 非单例模式(多用户实例)
 */
module.exports = class {
    // 设置基础信息
    constructor(opts) {
        if (opts) {
            this.conf(opts);
        }
        // API请求对象
        this.KRequest = new KRequest(this);
    };
    // 设置基础信息
    // opts = {LOGIN: {account, password}, APIHOST: {protocol, serveraddr, language}, NETPROXY: {useproxy, protocol, url, host, prot, account, password}}
    conf(opts, cb) {
        let that = this;
        let serveraddr = opts.APIHOST.serveraddr;
        var _doconf = function (opts) {
            // 服务器信息
            that.LOGIN = Utils.extendAttr({ account: '', password: '', oncepasswd: '', ksession: {} }, opts.LOGIN ? opts.LOGIN : {});
            // 网络代理信息
            that.APIHOST = Utils.extendAttr({ protocol: '', serveraddr: '', language: '' }, opts.APIHOST ? opts.APIHOST : {});
            // 登录信息
            that.NETPROXY = Utils.extendAttr({ useproxy: false, protocol: 'http', url: '', host: '', prot: '', account: '', password: '' }, opts.NETPROXY ? opts.NETPROXY : {});
            // this.KRequest.KSession = this;

            //console.log(that.APIHOST)
        }
        if(cb && this.KRequest){
            this.KRequest.request('GET', 'http://' + serveraddr + '/kabala/open?op=queryserver', {}, true).then((server) => {
                try {
                    let rsakey = server && server.rsakey ? server.rsakey: undefined;
                    let protocol = server && server.endpoint ? server.endpoint.substring(0, server.endpoint.indexOf(':')) : '';
                    opts.APIHOST.protocol = protocol ? protocol : opts.APIHOST.protocol;
                    opts.NETPROXY.protocol = protocol ? protocol : opts.NETPROXY.protocol;
                    if(rsakey){
                        let words    = Kcrypto.enc.Base64.parse(rsakey);
                        let parseStr = words.toString();
                        var encrypt = new JSEncrypt();
                        encrypt.setPublicKey(parseStr);
                        let password = encrypt.encrypt(opts.LOGIN.password);
                        if (password) {
                            opts.LOGIN.password = password;
                        }
                    }
                } catch (e) { console.error(e) }
                _doconf(opts);
                if (cb) {
                    cb();
                }
            }).catch( (err) => {
                console.error(err)
                // 查询服务出错后继续执行
                _doconf(opts);
                if (cb) {
                    cb();
                }
            });
        }else{
            _doconf(opts);
        }
    };
    // 设置服务器会话信息
    setKServerSession(session) {
        this.LOGIN.ksession = session ? session : null;
    };
    // 获取用户ID
    get userAccount() {
        return this.LOGIN.account ? this.LOGIN.account : '';
    };
    // 获取服务器地址
    get serverAddr() {
        return (this.APIHOST.protocol + "://" + this.APIHOST.serveraddr).formatURL();
    };
    // 服务器会话信息
    get serverSession() {
        return this.LOGIN.ksession;
    };
    // 获取网络代理URL
    get netProxyURL() {
        if (this.NETPROXY.useproxy) {
            if (this.NETPROXY.url) {
                return this.NETPROXY.url;
            }
            return this.NETPROXY.protocol + '://' + this.NETPROXY.account + ':' + this.NETPROXY.password + '@' + this.NETPROXY.host + ':' + this.NETPROXY.prot;
        }
        return '';
    };
    // 获取space列表
    get spaceList() {
        return this.LOGIN.ksession && this.LOGIN.ksession.spaces ? this.LOGIN.ksession.spaces : [];
    };
};