"use strict";
const { ipcMain } = require('electron');
/**
 * ipcMain 1.8.2 版本补丁
 * 模拟自定义的实现, 不保证和最新源代码完全一致 --wupeng
 */

if (!ipcMain.handle) {
    ipcMain.handle = (channel, func) => {
        let handChannel = 'h-' + channel;
        ipcMain.on(handChannel, (e, replaykey, ...args) => {
            Promise.resolve(func(e, ...args)).then((datas) => {
                e.sender.send(replaykey, { datas: datas });
            }).catch((err) => {
                e.sender.send(replaykey, { error: "'" + channel + "': " + (err.message ? err.message : err.toString()) });
            });
        });
    };
}
if (!ipcMain.handleOnce) {
    ipcMain.handleOnce = (channel, func) => {
        let handChannel = 'h-' + channel;
        ipcMain.on(handChannel, (e, replaykey, ...args) => {
            Promise.resolve(func(e, ...args)).then((datas) => {
                e.sender.send(replaykey, { datas: datas });
            }).catch((err) => {
                e.sender.send(replaykey, { error: "'" + channel + "': " + (err.message ? err.message : err.toString()) });
            });
        });
    };
}
if (!ipcMain.removeHandler) {
    ipcMain.removeHandler = (channel) => {
        ipcMain.removeAllListeners('h-' + channel);
    };
}

module.exports = ipcMain;