"use strict";
const ipcMain = require('./kipcmain.js');
const { FrameTool } = require('kutils/lib/etools');
/**
  * 窗口接口
 **/
module.exports = class {
  constructor(id, wopts) {
    this.id = id ? id : this.ID();
    if (!this.id) {
      throw new Error('Frame id can not empty');
    }
    // 
    this._handlekeys = {};
    this.IPCHandles((key, func, once) => {
      this.doRegisterHandle(key, func, once);
    });
    this.opts = wopts ? wopts : this.Opts();
    this.win = FrameTool.create(this.id, this.opts);
    this.win.on('closed', (e) => {
      let keys = Object.keys(this._handlekeys);
      if (keys && keys.length > 0) {
        for (let i = 0; i < keys.length; i++) {
          ipcMain.removeHandler(keys[i]);
        }
      }
    });
  };
  // 窗口id
  ID() { };
  // 窗口配置
  Opts() {
    return {};
  };
  // 注册IPCManHandle 
  IPCHandles(register) {
    // register('id', (e) => { }); // 实际注册 key = 窗口ID + ':' + 注册id
  };
  // 执行注册 handle
  doRegisterHandle(key, func, once) {
    let tkey = this.id + ':' + key;
    if (once) {
      this._handlekeys[tkey] = '';
      ipcMain.handleOnce(tkey, func);
    } else {
      this._handlekeys[tkey] = '';
      ipcMain.handle(tkey, func);
    }
  };
  // 删除 handle
  doRemoveHandle(key) {
    let tkey = this.id + ':' + key;
    ipcMain.removeHandler(tkey);
    delete this._handlekeys[tkey];
  };
  // 显示
  show() {
    if (this.win) {
      this.win.show();
    }
  };
  // 隐藏
  hide() {
    if (this.win) {
      this.win.hide();
    }
  };
  // 最小化
  mini() {
    if (this.win) {
      this.win.minimize();
    }
  };
  // 切换大小
  togglemax() {
    if (this.win) {
      if (this.win.isMaximized()) {
        this.win.unmaximize();
      } else {
        this.win.maximize();
      }
    }
  }
};