"use strict";
const { KSession, FrameTool } = require('ksdk');
const { Klogin } = require('kapis');
const { app } = require('electron');

// 客户端全局通用函数
module.exports = class {
    static _cf = null;
    // 显示登录页面
    static showLogin() {
        KSession.setKServerSession();
        let frames = FrameTool.list();
        if (frames) {
            for (let key in frames) {
                if (key == 'login') {
                    continue;
                }
                if (frames[key] && frames[key].destroy) {
                    try {
                        frames[key].destroy();
                    } catch (e) { }
                }
            }
        }
        if (frames['login']) {
            try {
                frames['login'].show();
            } catch (e) { }
        }
    };
    // 设置当前窗口
    static setCurrentFrame(frame) {
        this._cf = frame;
    };
    // 显示当前窗口
    static showCurrentFrame() {
        if (this._cf) {
            this._cf.show();
        }
    };
    // 注销客户端会话
    static doLogout(cb) {
        Klogin.logout().then(() => {
            this.showLogin(); if (cb) { cb(); };
        }).catch((err) => {
            this.showLogin(); if (cb) { cb(); };
        });
    };
    // 退出app
    static doQuit(force) {
        if (force) {
            app.exit(); return;
        }
        Klogin.logout().then(() => {
            app.exit();
        }).catch((err) => {
            app.exit();
        });
    };

};