"use strict";
const { KFrameAbstract } = require('ksdk');
/**
  * 普通窗口
 **/
module.exports = class extends KFrameAbstract {
  constructor(logger, url, title, wopts) {
    super('normalframe_' + (url.getMd5()));
    this.url = url;
    this.logger = logger ? logger : console;
    this.title = title;
    this.wopts = wopts ? wopts : {};
    if (url.startWith('http://') || url.startWith('https://')) {
      this.win.loadURL(url);
    } else {
      this.win.loadFile(url);
    }
    if (wopts.showdev) {
      this.win.webContents.openDevTools()
    }
    this.win.once('ready-to-show', (e) => {
      this.win.show();
      this.win.focus();
    });
  }
  // 窗口配置
  Opts() {
    return {
      title: this.title,
      show: false,
      frame: true,
      width: this.wopts && this.wopts.width ? this.wopts.width : 1366,
      height: this.wopts && this.wopts.height ? this.wopts.height : 768,
    }
  };

  // 组成事件函数
  IPCHandles(register) {
    // 主窗体: 显示窗口
    register('show', () => { this.show(); });
    // 主窗体: 最小化
    register('mini', () => { this.mini(); });
    // 主窗体: 隐藏
    register('hide', () => { this.hide(); });
    // 主窗体: 最大化 <-> 最小化
    register('togglemax', () => { this.togglemax(); });
    // 重定向window.open
    // register('window.open', (e, url) => {
    //   this.logger.info('window.open');
    // });

  };

  static mkWinID(url) {
    return 'normalframe_' + (url.getMd5());
  }
};