"use strict";
/**
 * 助手修改
 */
var lockjob = undefined;
const lockqueen = new Map();
const watchmap = new Map();
const fileSys = require('fs');
const Job = require('node-schedule');
const { FSTools, FrameTool, Utils } = require('kutils');
const openAsLocal = require('../lib/openaslocal');
const { KDownloadTool, KUploadTool, KClient } = require('kcomm');
module.exports = class {
    constructor(spacepath, kspace) {
        this.spacepath = spacepath;
        this.KSpace = kspace;
        this._frame = null;
        this.initJob();

        this.lastopts = {
            opt: '',       // 最后执行的操作
            always: false, // 记住
        };
    };
    setLogger(logger) {
        if (logger) {
            this.logger = logger;
        }
    };
    // 执行操作
    async doStart() {
        try {
            let cdl = new cacheDownload(this.spacepath, this.KSpace);
            cdl.setLogger(this.logger);
            cdl.onOpend = async () => {
                if (FSTools.isFileSync(cdl.cachepath)) {
                    // 锁定并监控
                    await this.KSpace.lockfile(cdl.spacepath);
                    this.logger.info('锁定文件', cdl.spacepath);
                    this.cacheinfo = cdl.item;
                    this.watch = fileSys.watch(cdl.cachepath, { persistent: false }, async (etype, fname) => {
                        this.logger.log(etype, fname);
                        if (etype == 'change') {
                            /*
                            // linux 下文件不加锁
                            let testpath = cdl.cachepath + '.watch';
                            FSTools.removeSync(testpath)
                            let succeed = FSTools.renameSync(cdl.cachepath, testpath.getName());
                            if (succeed) {
                                this.logger.log('editend', testpath);
                            }
                            */
                            this.isChanged().then((data) => {
                                this.logger.info('文件被改变', data);
                                this.doStartUpload();
                            });
                        }
                    });
                    if (this.watch) {
                        watchmap.set(cdl.cachepath, this.watch);
                        lockqueen.set(this.spacepath,cdl.cachepath);
                    }
                }
            }
             // 尝试打开本地缓存文件...
             cdl.tryOpenLocal( ()=>{ cdl.doAction()/* 从云端下载然后打开 */ }, (func, data) => { this.onConFirm( func, data ) } /* 对比后若有冲突让用户选择打开哪份 */ );
        } catch (err) {
            this.logger.error(err); throw err;
        }
    };
    // 避免在短时间内重复保存 - 延迟保存
    doStartUpload() {
        if (this.settimeoutexec) {
            clearTimeout(this.settimeoutexec);
            this.settimeoutexec = null;
            this.logger.info('延迟保存', this.cacheinfo.dest);
        }
        this.settimeoutexec = setTimeout(() => {
            this.logger.info('执行保存', this.cacheinfo.dest);
            this.doUpload(this.cacheinfo.dest, this.spacepath);
        }, 2000);
    };
    // 对比是否改变
    isChanged() {
        return new Promise((resolve, reject) => {
            if (this.cacheinfo && this.cacheinfo.node) {
                let oldnode = this.cacheinfo.node.versions[0];
                if (oldnode.datasize != FSTools.fileSizeSync(this.cacheinfo.dest)) {
                    resolve({ type: 'size' }); return;
                };
                FSTools.getMD5Async(this.cacheinfo.dest, (md5) => {
                    if (md5 && oldnode.datahash.toLowerCase() != md5.toLowerCase()) {
                        resolve({ type: 'datahash' }); return;
                    }
                });
            }
        })
    };
    // 上传缓存
    async doUpload(loclpath, spacepath) {
        try {
            let kupload = new KUploadTool([loclpath], spacepath.getParent(), this.KSpace);
            kupload.setLogger(this.logger);
            kupload.doBuildItem = (item) => {
                item.dest = spacepath;
            };
            kupload.onTransferEnd = (datas) => {
                try {
                    if (datas && datas.allcount == datas.allsucceed) {
                        kupload.stop();
                        KClient.showNotice('助手修改', this.cacheinfo.src.getName() + ' 已保存');
                        if (!FSTools.isExistsSync(this.cacheinfo.dest)) {
                            (async () => {
                                await KClient.sleep(5000); // 休眠5s
                                if (!FSTools.isExistsSync(this.cacheinfo.dest)) {
                                    this.watch.close(); return;
                                }
                            })();
                        }
                        this.KSpace.getnode(this.cacheinfo.src).then((node) => {
                            this.logger.info('保存后更新', this.cacheinfo.dest, node);
                            this.cacheinfo.node = node;
                            savedatahash(loclpath.getParent(), {path: node.path, savedhash: node.versions[0].datahash } );
                        }).catch((err) => {
                            this.logger.error(err);
                        });
                    }
                } catch (err) {
                    this.logger.error(err);
                }
            };
            await kupload.doAction();
            // kupload.stop();
        } catch (err) {
            this.logger.error(err); throw err;
        }
    };
    // 自动解锁定时任务
    async initJob(){
        if(lockjob){
            return;
        }
        let job = Job.scheduleJob('0/30 * * * * ? ', () => {
            try{
                if(lockqueen){
                    for(let [spacepath, loclpath] of lockqueen) {
                        if(FSTools.isFreed(loclpath)){
                            try {
                                this.KSpace.unlockfile(spacepath);
                                this.logger.info('锁定文件', spacepath);
                                lockqueen.delete(spacepath);
                                // TODO 当 FSTools.isFreed 准确率达到100%时再加上
                                // let watch = watchmap.get(loclpath)
                                // if(watch){
                                //     console.log('watch close =>'+ loclpath)
                                //     watch.close();
                                // }
                            } catch (err) {
                                this.logger.info('锁定文件失败', spacepath, err);
                            }
                        }
                    }
                }
            }catch(e){
                console.log(e)
            }
        });
        if(job){
            lockjob = job;
            console.log('=> initJob')
        }
    };
    // 冲突确认操作
    async onConFirm( cb , data ) {
        this._frame = new ConfirmFrame();

        let win = await this.showPage( data );
        win.show(); win.focus(); win.setAlwaysOnTop(true);
        // this._frame.doLoadFile('./page/page-kcomm/confirm.html', data );
        // this._frame.show();
        // this._frame.setAlwaysOnTop(true);

        this._frame.win.on('closed', (e) => { this._frame = null;  this.stop();});
        // 注册控制事件 { opt: 'retry, stop, break', always: false }
        this._frame.doRegisterHandle('confirm', async (e, opt, always) => {
            if(opt=='cancel'){
                this.stop(); return;
            }else if(opt==='opencloud'){
                let oal = new openAsLocal(this.spacepath, this.KSpace);
                await oal.doStart(); return;
            }else if(cb){
                cb(opt);
                this.stop();
            }
        });
        // 不稳定
        // setTimeout(() => {
        //     if (this._frame && this._frame.win) {
        //         this._frame.win.webContents.send('c-dt',{ title: '文件内容冲突', tips:'本地文件与云端文件内容不一致,是否确认打开本地文件进行编辑?' });
        //     }
        // }, 1000);
    };
    // 启动页面 - override
    async showPage( data ) {
        return this._frame.doLoadFile('./page/page-kcomm/confirm.html', data );
    };
    // 停止
    stop() {
        if (null != this._frame) {
            try {
                this._frame.win.destroy();
            } catch (e) { this.logger.error(e); }
            this._frame = null;
        }
    };
};
/**
* 助手修改 - 下载
*/
class cacheDownload extends KDownloadTool {
    constructor(spacepath, kspace) {
        let os = require('os');
        super([spacepath], FSTools.parsePath(os.tmpdir() + '/kabalaclient/files/editaslocal/'), kspace);
        this.spacepath = spacepath;
        this.KSpace = kspace;
    };
    // 构建item
    doBuildItem(item) {
        try {
            this.item = item;
            this.cachepath = FSTools.parsePath(this.localdir + '/' + item.node.cnum + '/' + item.src.getName()); // item.node.cnum + item.src.getSuffixed());
            if (FSTools.isFileSync(this.cachepath)) {
                let oldwatch = watchmap.get(this.cachepath);
                if (oldwatch) {
                    try { oldwatch.close(); } catch (err) { this.logger.error(err); }
                }
                FSTools.removeSync(this.cachepath);
            }
            item.dest = this.cachepath;
            this.logger.info('editaslocal-download', item);
        } catch (e) {
            let err = { error: e, msg: '下载失败[' + e.toString() + ']', stage: 'validation', opts: ['retray'] };
            if (e && e.code == 'EBUSY') {
                err.msg = '文件已经打开或被系统占用';
            }
            throw err;
        }
    };
    // 下载结束
    onTransferEnd(datas) {
        if (datas && datas.allcount == datas.allsucceed) {
            this.stop();
            setTimeout(this.onOpend);
            openWithDefaultOption(this.cachepath, (err, stdout, stdin) => {
                if (err) {
                    this.logger.error(err);
                }
                this.logger.info(stdout);
                savedatahash(this.cachepath.getParent(), {path: this.item.node.path,savedhash: this.item.node.versions[0].datahash })
            });
        }
    };
    // 打开文件的回调函数 - override
    onOpend() {
        throw 'must override onOpend method';
    };
    
    async tryOpenLocal(doDownload, doConFirm) {
        let node = (await this.KSpace.getNodes([this.spacepath]))[0];
        this.cachepath = FSTools.parsePath(this.localdir + '/' + node.cnum + '/' + node.path.getName());
        // 直接打开本地文件
        var open = () => {
            let oldwatch = watchmap.get(this.cachepath);
            if (oldwatch) {
                try { oldwatch.close(); } catch (err) { this.logger.error(err); }
            }
            this.item = {
                src: this.spacepath,
                dest:  this.cachepath,
                node: node,
                isfile: true,
            };
            setTimeout(this.onOpend);
            openWithDefaultOption(this.cachepath, (err, stdout, stdin) => {
                if (err) {
                    this.logger.error(err);
                }
                this.logger.info(stdout);
            });
        }
       
        // 下载最新版并打开
        var downloadopen = () =>{
            if (doDownload) {
                doDownload();
            }
        }

        var framedata = {
            title: '修改冲突提示',
            tips: '云端文件在您上次打开期间发生了变动，建议您查看云端最新版后进行处理',
            filepath: this.spacepath,
            filename: this.cachepath.getName(),
            version: 'v'+node.versions[0].showversion,
            vuser: node.versions[0].vuser,
            vtime: node.versions[0].vtime,
            localversion:'',
        };
        // 手动确认冲突
        var confirm = () => {
            try {
                //没有相同版本,说明本地可能是最新的
                //{ msg: '版本冲突[本地与云端文件版本冲突,是否使用本地文件.]' }
                doConFirm((res) => {
                    if (res === 'local') {
                        open();

                    } else if (res === 'cloud') {
                        downloadopen();

                    } else if (res === 'diff') {
                        // TODO

                    } else {
                        return;
                    }
                }, framedata);
            } catch (e) {
                console.error(e)
            }
        }

        /*
        1、 localfile not exist, 下载最新版覆盖
        2、 localfile exist  && savedhash == NULL, 冲突提示       
        3、 savedhash == current_datahash, 直接打开本地文件
        4、 savedhash == histy_datahash && savedhash == filehash, 下载最新版覆盖
        5、 savedhash == histy_datahash && savedhash != filehash, 冲突提示(需要比较和文件的datahash)
        6、 savedhash != histy_datahash, 冲突提示
        */
        let savedhash = getdatahash( this.cachepath.getParent() , this.spacepath);
        if (!FSTools.isFileSync(this.cachepath)) {
            downloadopen();
            this.logger.info({ type: 'editcontrl 1', src: this.cachepath ,savedhash: savedhash });

        }else if( !savedhash ){

            FSTools.getMD5Async(this.cachepath, (filedatahash) => {
                filedatahash = filedatahash ? filedatahash.toLowerCase():'';
                if( filedatahash == node.versions[0].datahash ){
                    open();
                    this.logger.info({ type: 'editcontrl 2-1', src: this.cachepath ,filedatahash: filedatahash });

                }else if( node.versions.length>1 ){

                    let versions = node.versions;
                    let i = 1;
                    for (; i < versions.length; i++) {
                        if ( filedatahash === versions[i].datahash ) {
                            framedata.localversion = 'v' + versions[i].showversion;
                            break;
                        }
                    }

                    if( i<versions.length ){
                        downloadopen();
                        this.logger.info({ type: 'editcontrl 2-2', src: this.cachepath ,filedatahash: filedatahash });

                    }else{
                        confirm();
                        this.logger.info({ type: 'editcontrl 2-3', src: this.cachepath ,filedatahash: filedatahash });
                    }

                } else{
                    confirm();
                    this.logger.info({ type: 'editcontrl 2-3', src: this.cachepath ,savedhash: savedhash });
                }
            });

        }else if( savedhash==node.versions[0].datahash ){
            open();
            this.logger.info({ type: 'editcontrl 3', src: this.cachepath ,savedhash: savedhash });

        }else if( node.versions.length>1 ){

            let versions = node.versions;
            let i = 1;
            for (; i < versions.length; i++) {
                if (versions[i].datahash === savedhash) {
                    framedata.localversion = 'v' + versions[i].showversion;
                    break;
                }
            }
            if( i<versions.length ){
                FSTools.getMD5Async(this.cachepath, (filedatahash) => {
                    filedatahash = filedatahash ? filedatahash.toLowerCase():'';
                    if( filedatahash == savedhash ){
                        downloadopen();
                        this.logger.info({ type: 'editcontrl 4', src: this.cachepath ,savedhash: savedhash });

                    }else{
                        confirm();
                        this.logger.info({ type: 'editcontrl 5-1', src: this.cachepath ,savedhash: savedhash });
                    }
                });
            }else{
                confirm();
                this.logger.info({ type: 'editcontrl 6-1', src: this.cachepath ,savedhash: savedhash });
            }

        }else{
            confirm();
            this.logger.info({ type: 'editcontrl 6-2', src: this.cachepath ,savedhash: savedhash });
        }
        return;
    };
};

// ----------------------
const childProcess = require('child_process');
const KFrameAbstract = require('ksdk/lib/kframeabstract');
// 执行本地cmd命令
function executeCmdAsync(cmdStr, callback, option) {
    return childProcess.exec(cmdStr, Utils.extendAttr({ "encoding": "utf-8" }, option), callback);
};

// 调用系统默认打开方式打开
function openWithDefaultOption(path, callback) {
    if (process.platform == 'win32') {
        return executeCmdAsync("explorer \"" + FSTools.parsePath(path) + "\"", callback);
    } else if (process.platform == 'darwin') {
        return executeCmdAsync("open \"" + FSTools.parsePath(path) + "\"", callback);
    } else {
        return executeCmdAsync("xdg-open \"" + FSTools.parsePath(path) + "\"", callback);
    }
};

function savedatahash(parentPath, savemap) {
    try {
        FSTools.writeFileSync(FSTools.parsePath(parentPath+'/saved.json'), JSON.stringify(savemap));
    } catch (e) {
        console.error(e);
    }
   
};
function getdatahash(parentPath, path) {
    try {
        let jsonpath = FSTools.parsePath(parentPath+'/saved.json');
        if(FSTools.isExistsSync(jsonpath)){
            let map =  JSON.parse(FSTools.readFileSync(jsonpath, 'utf-8'));
            if(map.path==path){
                return map.savedhash;
            }
        }
        return '';
    } catch (e) {
        console.error(e);
        return '';
    }
};

// 传输进度窗体 - 版本冲突
// 传输进度窗体
class ConfirmFrame extends KFrameAbstract {
    constructor() {
        super('confirm' + "-" + Utils.random(), {
            show: false,
            frame: false,
            width: 560,
            height: 400,
            resizable: false,
            webPreferences: {
                nodeIntegration: true
            }
        });
        this._init();
    }
    // 注册事件函数
    IPCHandles(register) {
        // 主窗体: 显示窗口
        register('show', () => { this.show(); });
        // 主窗体: 最小化
        register('mini', () => { this.mini(); });
        // 主窗体: 隐藏
        register('hide', () => { this.hide(); });
        // 主窗体: 关闭
        register('close', () => { this.win.destroy(true); });
        // 主窗体: 最大化 <-> 最小化
        register('togglemax', () => { this.togglemax(); });
    };
    // init
    _init() {
        this.win.on('close', (e) => {
            e.preventDefault();
        });
    };
    // 加载一个实现了传输进度的页面
    async doLoadFile(localfile, data) {
        return new Promise((resolve, reject) => {
            try {
                this.win.loadFile(localfile);
                this.win.on('ready-to-show', () => {
                    this.win.webContents.send('set-frameid', this.id);
                    if(data){
                        this.win.webContents.send('set-data', data);
                    }
                    resolve(this.win);
                });
            } catch (err) {
                reject(err);
            }
        });
    };
};