"use strict";
const { KDownloadTool, KClient  } = require('kcomm');
const { FrameTool } = require('kutils');
const { dialog } = require('electron')
/**
 * 下载
 */
module.exports = class extends KDownloadTool {
    constructor(paths, kspace) {
        super(paths, 'unset', kspace);
        this.parentwin = FrameTool.get('main');
        if (!this.parentwin) {
            this.parentwin = FrameTool.get('login');
        }
        this.KSpace = kspace;
    };
    // 构建item
    doBuildItem(item) {
        super.doBuildItem(item);
    };
    // 下载结束
    onTransferEnd(datas) {
        if (datas && datas.allcount == datas.allsucceed) {
            this.stop();
            KClient.showNotice('下载完毕');
        }
    };
    // 执行操作
    async doStart() {
        return new Promise((resolve, reject) => {
            this.parentwin.setAlwaysOnTop(true);
            Promise.resolve(dialog.showOpenDialog(this.parentwin, { title: '保存位置', properties: ['openDirectory', 'createDirectory'] })).then((datas) => {
                this.parentwin.setAlwaysOnTop(false);
                let dir = typeof datas == 'object' && datas.filePaths ? datas.filePaths : datas;
                if (!dir || dir.length <= 0) {
                    // reject('取消操作');
                    return;
                }
                this.localdir = dir[0];
                this.doAction().then(resolve).catch(reject);
            }).catch((err) => {
                this.parentwin.setAlwaysOnTop(false);
                this.logger.error(err);
            });
        })
    };
};