'use strict';
const { EventEmitter } = require('events');
const { ReqTools, FSTools, Utils } = require('kutils');
const KU_EVENT = { PROGRESS: 'progress', ERROR: 'error', ABORT: 'abort', END: 'end' };
const KU_OPTS = { RETRAY: 'retray', COVER: 'cover', STOP: 'stop' };
/**
 * 上传单个文件
    let kuh = new KUploadHandler('M:/upload-test.exe', { filepath: '@900000000xtenantdoc/docs/upload-test/upload-test.exe' });
    kuh.on('error', (err) => { });
    kuh.on('progress', (ps) => { });
    kuh.on('end', () => { });
    kuh.start();
 */
module.exports = class extends EventEmitter {
    // 
    constructor(localpath, opts, kspace) {
        super();
        if (!localpath) {
            throw new Error('localpath is empty');
        }
        this._localpath = localpath; this._translatedsize = 0; this._timeStart = -1;
        this._opts = Utils.extendAttr({ filepath: '', filemd5: '', filesize: '', chunksize: 10 * 1024 * 1024, expiredSecond: '', hopesrvs: '', uptoken: '', isfile: true }, opts);
        if (!this._opts.filepath && !this._opts.datahash) {
            throw new Error('filepath is empty');
        }
        this.KSpace = kspace ? kspace : require('kapis/lib/kspace');
        this.md5Reader = null; this.partUploader = null;
    };
    // 启动
    async start() {
        try {
            if (!FSTools.isExistsSync(this._localpath)) {
                throw '文件不存在: ' + this._localpath;
            }
            if(FSTools.isDIRSync(this._localpath)){
                this._doMkDirs();
                return;
            }
            // 计算md5
            this._opts.filesize = FSTools.fileSizeSync(this._localpath);
            this.md5Reader = FSTools.getMD5Async(this._localpath, (md5) => {
                this.md5Reader = null;
                this._opts.filemd5 = md5;
                this._sendPartStream();
            });
            // 计算时- 进度条
            if (this.md5Reader) {
                let calcsize = 0;
                this.md5Reader.on('data', (chunk) => {
                    calcsize += chunk.length;
                    let ps = Utils.calcPercentage(calcsize, this._opts.filesize);
                    this.emit(KU_EVENT.PROGRESS, { progress: ps, stage: 'calcmd5' });
                });
            } else {
                throw '读取文件失败';
            }
        } catch (err) {
            this.abort();
            this.emit(KU_EVENT.ERROR, { error: err, msg: '上传失败[' + err.toString() + ']', stage: '', opts: [KU_OPTS.RETRAY] });
        }
    };
    // 获取上传信息
    async _askUpload() {
        //console.log('this._opts', this._opts)
        // 获取上传url
        // datasrv: 2001
        // expiredtime: 20201224062136
        // httpurl: "http://192.168.2.72:5775/kabala/2001/token/upmult2001qmzxjavs20122406213606kabalaab66e020111963a6378412641a2bfb16x714935638/1"
        // partmaxsize: -1
        // partminsize: -1
        // partnumber: 1
        // upmethod: "POST"
        // uptoken: "upmult2001qmzxjavs20122406213606kabalaab66e020111963a6378412641a2bfb16x714935638"
        if (this._opts.uptoken) {
            let uploaded = await this.KSpace.queryuploaded(this._opts.spacepath, this._opts.uptoken);
            if (!uploaded || uploaded.length == 0) {
                return await this.KSpace.askupload(...Object.values(this._opts));
            } else {
                // 待完善
                return { uptoken: this._opts.uptoken, partnumber: 1 };
            }
        } else {
            return await this.KSpace.askupload(...Object.values(this._opts));
        }
    };
    async _doMkDirs() {
        try {
            let dirpath = this._opts.filepath;
            if (!await this.KSpace.getnode(dirpath)) {
                await this.KSpace.mkdirs(dirpath);
            }
            let node = this.KSpace.getnode(dirpath);
            this.emit(KU_EVENT.END, { node: node, msg: '上传成功', stage: 'domkdirs' });
        } catch (err) {
            this.emit(KU_EVENT.ERROR, { error: err, msg: '上传失败[' + err.toString() + ']'});
        }
    }
    // 发送数据
    async _sendPartStream() {
        // 获取上传令牌
        let tokenDatas = {};
        try {
            tokenDatas = await this._askUpload();
        } catch (err) {
            let Error = err;
            // 尝试先创建文件夹
            try {
                let parentdir = this._opts.filepath.getParent();
                if (!await this.KSpace.getnode(parentdir)) {
                    await this.KSpace.mkdirs(parentdir);
                }
                tokenDatas = await this._askUpload();
                Error = undefined;
            } catch (e) {
                Error = e;
            }
            if(Error){
                this.emit(KU_EVENT.ERROR, { error: err, msg: '上传失败, 无法获得上传地址[' + err.toString() + ']', stage: 'askupload', opts: [KU_OPTS.RETRAY] }); return;
            }
        }
        if (tokenDatas.upmethod.toUpperCase() != 'HIT') {
            // 上传单片
            this._timeStart = new Date().getTime();
            let partCount = Math.ceil(this._opts.filesize / this._opts.chunksize);
            for (let i = tokenDatas.partnumber; i <= partCount; i++) {
                try {
                    this.partUploader = new PartUploader(this._localpath, this._opts.filepath, tokenDatas.uptoken, this._opts.chunksize, i);
                    this.partUploader.KSpace = this.KSpace;
                    this.partUploader.on(KU_EVENT.PROGRESS, (psInfo) => {
                        if (psInfo && psInfo.translatedSize > 0) {
                            this._translatedsize += psInfo.chunkSize;
                            let spentTime = new Date().getTime() - this._timeStart;
                            let ps = Utils.calcPercentage(this._translatedsize, this._opts.filesize);
                            let speed = this._translatedsize / spentTime; // byte / ms 
                            this.emit(KU_EVENT.PROGRESS, { translatedSize: this._translatedsize, dataSize: this._opts.filesize, spentTime: spentTime, progress: ps, speed: speed });
                        }
                    });
                    await this.partUploader.start();
                } catch (err) {
                    this.abort();
                    this.emit(KU_EVENT.ERROR, { error: err, msg: '上传失败[' + err.toString() + ']', stage: 'partupload', opts: [KU_OPTS.RETRAY] }); return;
                }
            }
        }
        // 提交令牌
        try {
            let parentdir = this._opts.filepath.getParent();
            if (!await this.KSpace.getnode(parentdir)) {
                await this.KSpace.mkdirs(parentdir);
            }
            let node = await this.KSpace.submitupload(this._opts.filepath, tokenDatas.uptoken);
            this.emit(KU_EVENT.END, { node: node, msg: '上传成功', stage: 'submitupload' },);
        } catch (err) {
            this.emit(KU_EVENT.ERROR, { error: err, msg: '上传失败[' + err.toString() + ']', stage: 'submitupload', opts: [KU_OPTS.RETRAY] });
        }
    };
    // 停止
    abort() {
        if (this.md5Reader) {
            try {
                this.md5Reader.close();
            } catch (e) { }
        }
        if (this.partUploader) {
            try {
                this.partUploader.abort();
            } catch (e) { }
        }
    };
};

// 上传单片
class PartUploader extends EventEmitter {
    constructor(loclpath, spacepath, uptoken, partsize, partnumber) {
        super();
        if (!loclpath) {
            throw 'loclpath is empty';
        }
        if (!spacepath) {
            throw 'spacepath is empty';
        }
        if (!uptoken) {
            throw 'uptoken is empty';
        }
        if (!partsize || partsize < 0) {
            throw 'partsize < 0';
        }
        if (!partnumber || partnumber < 0) {
            throw 'partnumber < 0';
        }
        this._loclpath = loclpath;
        this._spacepath = spacepath;
        this._uptoken = uptoken;
        this._partnumber = partnumber;
        this._partsize = partsize;
        this._translatedsize = 0;
        this.KSpace = require('kapis/lib/kspace');
    };
    // 执行
    async start() {
        // atasrv: 2001
        // expiredtime: 20201224062136
        // httpurl: "http://192.168.2.72:5775/kabala/2001/token/upmult2001qmzxjavs20122406213606kabalaab66e020111963a6378412641a2bfb16x714935638/1"
        // partmaxsize: -1
        // partminsize: -1
        // partnumber: 1
        // upmethod: "POST"
        // uptoken: "upmult2001qmzxjavs20122406213606kabalaab66e020111963a6378412641a2bfb16x714935638"
        let partInfo = await this.KSpace.exchangeupload(this._spacepath, this._uptoken, this._partnumber);
        if (!partInfo.httpurl) {
            throw 'httpurl is empty';
        }
        await this._sendStream(partInfo);
    };
    // post 上传
    async _sendStream(partInfo) {
        return new Promise((resolve, reject) => {
            if (!FSTools.isFileSync(this._loclpath)) {
                throw '文件不存在: ' + this._loclpath;
            }
            let readStream = FSTools.readPartStreamSync({
                filePath: this._loclpath,
                partNumber: this._partnumber,
                partSize: this._partsize
            });
            let reqopts = {
                headers: {
                    'User-Agent': '',
                    'Content-Type': '',
                    'Connection': 'keep-alive',
                    'Content-Length': readStream.option.contentSize,
                }
            };
            this.request = ReqTools.doRequest(partInfo.upmethod, partInfo.httpurl, reqopts);
            // 发送管道数据流, 数据流不是一次性读取完毕 [ end = false ]
            readStream.pipe(this.request, { end: false });
            // 进度条
            readStream.on('data', (chunk) => {
                if (chunk && chunk.length > 0) {
                    this._translatedsize += chunk.length;
                    this.emit(KU_EVENT.PROGRESS, { translatedSize: this._translatedsize, chunkSize: chunk.length });
                }
            });
            //readStream.on('end', () => {
            //    this.request.end();
            //});
            this.request.on('error', (err) => {
                try { readStream.close(); } catch (e) { }
                reject(err);
            });
            this.request.on('end', () => {
                resolve();
            });
            this.request.on('abort', () => {
                readStream.close();
            });
        });
    };
    // abort
    abort() {
        if (this.request) {
            this.request.abort();
        }
    };
};