"use strict";
let currentFrame = null;
const { Klogin } = require('kapis');
const { app, Notification } = require('electron');
const { KSession, FrameTool, FSTools } = require('ksdk');
const config = require('../../../config/config.json');

// 客户端全局通用函数
module.exports = class {

    static Config(){
        try {
            return config;
        } catch (e) {
            return {};
        }
    } 
    // 显示登录页面
    static showLogin() {
        KSession.setKServerSession();
        let frames = FrameTool.list();
        if (frames) {
            for (let key in frames) {
                if (key == 'login') {
                    continue;
                }
                if (frames[key] && frames[key].destroy) {
                    try {
                        frames[key].destroy();
                    } catch (e) { }
                }
            }
        }
        if (frames['login']) {
            try {
                frames['login'].show();
            } catch (e) { }
        }
    };
    // 设置当前窗口
    static setCurrentFrame(frame) {
        currentFrame = frame;
    };
    // 显示当前窗口
    static showCurrentFrame() {
        if (currentFrame) {
            currentFrame.show();
        }
    };
    // 注销客户端会话
    static doLogout(cb) {
        Klogin.logout().then(() => {
            this.showLogin(); if (cb) { cb(); };
        }).catch((err) => {
            this.showLogin(); if (cb) { cb(); };
        });
    };
    // 退出app
    static doQuit(force) {
        if (force) {
            app.exit(); return;
        }
        Klogin.logout().then(() => {
            app.exit();
        }).catch((err) => {
            app.exit();
        });
    };
    // 显示一条通知
    static showNotice(title, body) {
        let notice = new Notification({
            icon: FSTools.buildPath(__dirname, '../../../icon/icon.ico'),
            title: undefined != title ? title : '',
            body: undefined != body ? body : '',
        });
        notice.show();
        return notice;
    };
    // 线程休眠
    static async sleep(time) {
        return new Promise((resolve) => { setTimeout(resolve, time ? time : 0); });
    };
};