"use strict";
const fileSys = require('fs');
const FSTools = require('kutils/lib/fstools');
const KTransferAbstract = require('./ktransferabstract');
const KUploadHandler = require('../lib/kuploadhandler');
/**
 * 上传组件, 有页面
 */
module.exports = class extends KTransferAbstract {
    constructor(paths, spacedir, kspace) {
        super('upload');
        this.setTitle('正在上传');
        if (!paths) { throw '上传路径不能为空'; }
        if (!spacedir) { throw '保存位置不能为空'; }
        this.paths = paths ? paths : [];
        this.spacedir = spacedir ? spacedir : '';
        this.spaceroot = '';
        this.KSpace = kspace ? kspace : require('kapis/lib/kspace');
    };
    //
    setLogger(logger) {
        if (logger) { this.logger = logger; }
    };
    // 构建队列
    async doBuildQueue(addQueue) {
        // 
        async function doBuild(filePath, basedir) {
            return new Promise((reslove, reject) => {
                fileSys.readdir(filePath, (err, list) => {
                    if (err) { reject(err); return; }
                    if (list.length == 0) { reslove(); }
                    // 
                    let nextStat = (i) => {
                        if (list.length == i) {
                            reslove(); return; // 当前文件夹已经循环完毕, 返回
                        }
                        if (!list[i] || list[i].length == '') {
                            nextStat(++i); return;
                        }
                        let temppath = FSTools.parsePath(filePath + '/' + list[i]); // 子路径
                        fileSys.stat(temppath, async (err_stat, stat) => {
                            if (err_stat) { reject(err_stat); return; }
                            try {
                                if (stat) {
                                    addQueue({
                                        src: temppath,
                                        datasize: stat.isDirectory()?0:stat.size,
                                        basedir: basedir,
                                        isfile: !stat.isDirectory()
                                    });
                                    if (stat.isDirectory()) {
                                        await doBuild(temppath, basedir);
                                    }
                                    nextStat(++i); // 如果是文件则循环当前文件夹其他项目

                                } else {
                                    nextStat(++i); // 当前文件夹项目无效, 继续当前文件夹其他项目
                                }
                            } catch (e) {
                                reject(e);
                            }
                        });
                    };
                    nextStat(0);
                });
            });
        };
        // 
        this.spaceroot = this.KSpace.getSpaceRoot(this.spacedir);
        // 
        for (let i = 0; i < this.paths.length; i++) {
            let isfile = FSTools.isFileSync(this.paths[i]);
            if (isfile) {
                addQueue({
                    src: FSTools.parsePath(this.paths[i]),
                    datasize: FSTools.fileSizeSync(this.paths[i]),
                    basedir: '',
                });
            } else {
                await doBuild(this.paths[i], isfile ? '' : FSTools.getParent(this.paths[i]));
            }
        }
    };
    // 构建传输对象
    doBuildItem(item) {
        if (item.basedir) {
            item.dest = FSTools.parsePath(item.src.replace(item.basedir, this.spacedir), true);
        } else {
            item.dest = FSTools.parsePath(this.spacedir + '/' + item.src.getName(), true);
        }
    };
    // 获取传输对象
    doGetTransferObject(item) {
        return new KUploadHandler(item.src, {
            filepath: item.dest, isfile: item.isfile
            // filemd5:
        }, this.KSpace);
    };
    // progress
    onProcess(item, ps) {
        if (item && item.dest) {
            item.showdest = item.dest.replace(this.spaceroot, '');
        }
        if (this._ps.transferend) {
            this.setTitle('上传结束');
        }
        super.onProcess(item, ps);
    };
    // 传输结束
    onTransferEnd(datas) {

    };
}