"use strict";
const { FSTools } = require('kutils');
const KTransferAbstract = require('./ktransferabstract');
const KDownloadHandler = require('../lib/kdownloadhandler');
/**
 * 下载组件, 有页面
 */
module.exports = class extends KTransferAbstract {
    constructor(paths, localdir, kspace) {
        super('download');
        this.setTitle('正在下载');
        if (!paths) { throw '下载路径不能为空'; }
        if (!localdir) { throw '保存位置不能为空'; }
        this.pathbase = '';
        this.paths = paths ? paths : [];
        this.localdir = localdir ? localdir : '';
        this.KSpace = kspace ? kspace : require('kapis/lib/kspace');
    };
    //
    setLogger(logger) {
        if (logger) {
            this.logger = logger;
        }
    };
    // 构建队列
    async doBuildQueue(addQueue) {
        let doBuild = async (nodes) => {
            if (nodes) {
                let dirs = [];
                for (let i = 0; i < nodes.length; i++) {
                    if (!nodes[i] || !nodes[i].path) { continue; }
                    // if(nodes[i].isfile || nodes[i].path.getParent() != this.pathbase){
                        addQueue({ src: nodes[i].path,
                            datasize: nodes[i].isfile? nodes[i].versions[0].datasize: 0,
                            node: nodes[i],
                            isfile: nodes[i].isfile,
                        });
                    // }
                    if(!nodes[i].isfile){
                        dirs.push(nodes[i].path);
                    }
                }
                if (dirs.length > 0) {
                    for (let i = 0; i < dirs.length; i++) {
                        await doBuild(await this.KSpace.listdir(dirs[i], true, true));
                    }
                }
            }
        };
        this.spaceroot = this.KSpace.getSpaceRoot(this.paths[0]);
        this.pathbase = this.paths[0].getParent();
        let nodes = await this.KSpace.getNodes(this.paths);
        if (!nodes || nodes.length == 0) {
            throw '文件不存在';
        }
        await doBuild(nodes);
    };
    // 构建传输对象
    doBuildItem(item) {
        var newpath = FSTools.parsePath(item.src.replace(this.pathbase, this.localdir));
        var str = '/';
        if (newpath.indexOf('\\') > -1) {
            str = '\\';
        }
        var newparent = newpath.substring(0, newpath.lastIndexOf(str));
        var name = newpath.substring(newpath.lastIndexOf(str) + 1);
        var filetype = "";
        if (name.indexOf(".") > 0) {
            filetype = name.substring(name.lastIndexOf(".") + 1);
            name = name.substring(0, name.lastIndexOf("."));
        }
        if (name.length >= 70 - filetype.length) {
            name = name.substring(0, 70 - filetype.length - 1);
        }
        if (filetype) {
            name = name + "." + filetype;
        }
        item.dest = newparent + str + name;
    };
    // 获取传输对象
    doGetTransferObject(item) {
        return new KDownloadHandler(item.dest, {
            filepath: item.src, isfile: item.isfile
        }, this.KSpace);
    };
    // progress
    onProcess(item, ps) {
        if (item) {
            item.showsrc = item.src.replace(this.spaceroot, '');
            item.showdest = item.dest;
        }
        if (this._ps.transferend) {
            this.setTitle('下载结束');
        }
        super.onProcess(item, ps);
    };
    // 传输结束
    onTransferEnd(datas) {
    };
}
